/*
 * Decompiled with CFR 0.152.
 */
package com.caij.easypermissions;

import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.caij.easypermissions.BasePermissionManager;

public class PermissionFragment
extends Fragment {
    private BasePermissionManager permissionManager;
    private static final String PERMISSION_KEYS = "KEY_INPUT_PERMISSIONS";
    private static final String REQUEST_CODE = "request_code";

    static PermissionFragment newInstance(String[] permissions, int requestCode) {
        PermissionFragment fragment = new PermissionFragment();
        fragment.setArguments(PermissionFragment.newArgs(permissions, requestCode));
        return fragment;
    }

    static Bundle newArgs(String[] permissions, int requestCode) {
        Bundle args = new Bundle();
        args.putStringArray(PERMISSION_KEYS, permissions);
        args.putInt(REQUEST_CODE, requestCode);
        return args;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (this.permissionManager != null) {
            Bundle bundle = this.getArguments();
            if (bundle != null) {
                int requestCode = bundle.getInt(REQUEST_CODE, -1);
                this.permissionManager.requestPermissionType(this, requestCode);
            }
        } else if (this.getActivity() != null) {
            this.getActivity().getSupportFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
        }
    }

    public void setPermissionManager(BasePermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (this.permissionManager != null) {
            this.permissionManager.onRequestPermissionsResult(permissions, grantResults);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.permissionManager != null) {
            this.permissionManager.onSettingActivityResult(requestCode);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.permissionManager = null;
    }
}

