/*
 * Decompiled with CFR 0.152.
 */
package com.caij.easypermissions;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.caij.easypermissions.BasePermissionManager;
import com.caij.easypermissions.DefaultPermissionDialog;
import com.caij.easypermissions.ManageExternalStoragePermissionManager;
import com.caij.easypermissions.PermissionDialog;
import com.caij.easypermissions.PermissionListener;
import com.caij.easypermissions.PermissionManager;
import org.jetbrains.annotations.NotNull;

public class Permissions {
    private static final String TAG = "EasyPermissions";
    static final int SHOW_REASON_TYPE_NONE = 1;
    static final int SHOW_REASON_TYPE_BEFORE = 2;
    static final int SHOW_REASON_TYPE_AFTER = 3;
    static final int REQUEST_PERMISSION_CODE = 1013;
    static final int REQUEST_SETTING = 1011;
    static final int REQUEST_STORAGE_MANAGER = 1014;
    String[] permissions;
    int showReasonType = 1;
    PermissionListener permissionListener;
    final FragmentActivity fragmentActivity;
    PermissionDialog permissionDialog;

    public Permissions(FragmentActivity fragmentActivity) {
        this.fragmentActivity = fragmentActivity;
    }

    public static boolean hasPermissions(@NonNull Context context, String ... permissions) {
        if (Build.VERSION.SDK_INT < 23) {
            Log.w((String)TAG, (String)"hasPermissions: API version < M, returning true by default");
            return true;
        }
        for (String permission : permissions) {
            boolean hasPermission;
            boolean bl = hasPermission = ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0;
            if (hasPermission) continue;
            return false;
        }
        return true;
    }

    public static Permissions with(Fragment fragment) {
        return Permissions.with(fragment.getActivity());
    }

    public static Permissions with(FragmentActivity fragmentActivity) {
        return new Permissions(fragmentActivity);
    }

    public Permissions permissions(String ... permissions) {
        this.permissions = permissions;
        return this;
    }

    public Permissions showReasonBeforeRequest() {
        return this.showReasonBeforeRequest(new DefaultPermissionDialog());
    }

    public Permissions showReasonAfterRequest() {
        return this.showReasonAfterRequest(new DefaultPermissionDialog());
    }

    public Permissions showReasonBeforeRequest(PermissionDialog permissionDialog) {
        this.showReasonType = 2;
        this.permissionDialog = permissionDialog;
        return this;
    }

    public Permissions showReasonAfterRequest(PermissionDialog permissionDialog) {
        this.showReasonType = 3;
        this.permissionDialog = permissionDialog;
        return this;
    }

    public Permissions setPermissionDialog(PermissionDialog permissionDialog) {
        this.permissionDialog = permissionDialog;
        return this;
    }

    public void request(PermissionListener permissionListener) {
        this.permissionListener = permissionListener;
        if (this.permissions == null || this.permissions.length == 0) {
            throw new NullPointerException("permission null");
        }
        if (this.permissionDialog == null) {
            this.permissionDialog = new DefaultPermissionDialog();
        }
        BasePermissionManager permissionManager = null;
        for (String permission : this.permissions) {
            if (!permission.equals("android.permission.MANAGE_EXTERNAL_STORAGE")) continue;
            if (this.permissions.length == 1) {
                permissionManager = new ManageExternalStoragePermissionManager(this);
                break;
            }
            throw new RuntimeException("Special Permissions only support one");
        }
        if (permissionManager == null) {
            permissionManager = new PermissionManager(this);
        }
        permissionManager.request();
    }

    public static boolean askNever(@NonNull Activity activity, @NonNull String permission) {
        return ContextCompat.checkSelfPermission((Context)activity, (String)permission) == -1 && !ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission);
    }

    public static boolean askNever(@NotNull FragmentActivity fragmentActivity, @NotNull String[] permissions) {
        for (String permission : permissions) {
            if (!Permissions.askNever((Activity)fragmentActivity, permission)) continue;
            return true;
        }
        return false;
    }
}

