/*
 * Decompiled with CFR 0.152.
 */
package com.caij.sharedpreferences.mmkv;

import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.Nullable;
import com.tencent.mmkv.MMKV;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class MMKVSharedPreferences
implements SharedPreferences {
    private final String TYPE_SUFFIX = "_mtype";
    private static final int TYPE_INT = 1;
    private static final int TYPE_LONG = 2;
    private static final int TYPE_STRING = 3;
    private static final int TYPE_SET = 4;
    private static final int TYPE_FLOAT = 5;
    private static final int TYPE_BOOL = 6;
    private static final int TYPE_UNKNOW = -101;
    private final MMKV mmkv;
    private MMKV mmkvType;
    private int mode;
    private String fileName;
    private List<SharedPreferences.OnSharedPreferenceChangeListener> onSharedPreferenceChangeListeners;

    public MMKVSharedPreferences(String name, int mode) {
        this.fileName = name;
        this.mode = mode;
        this.mmkv = mode == 4 ? MMKV.mmkvWithID((String)name, (int)2) : MMKV.mmkvWithID((String)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MMKV getMmkvType() {
        MMKVSharedPreferences mMKVSharedPreferences = this;
        synchronized (mMKVSharedPreferences) {
            if (this.mmkvType == null) {
                this.mmkvType = this.mode == 4 ? MMKV.mmkvWithID((String)(this.fileName + "_mtype"), (int)2) : MMKV.mmkvWithID((String)(this.fileName + "_mtype"));
            }
        }
        return this.mmkvType;
    }

    public void importFromSharedPreferences(SharedPreferences preferences) {
        Map kvs = preferences.getAll();
        if (kvs != null && kvs.size() > 0) {
            SharedPreferences.Editor editor = this.edit();
            for (Map.Entry entry : kvs.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null) continue;
                if (value instanceof Boolean) {
                    editor.putBoolean(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Integer) {
                    editor.putInt(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Long) {
                    editor.putLong(key, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Float) {
                    editor.putFloat(key, ((Float)value).floatValue());
                    continue;
                }
                if (value instanceof String) {
                    editor.putString(key, (String)value);
                    continue;
                }
                if (value instanceof Set) {
                    editor.putStringSet(key, (Set)value);
                    continue;
                }
                Log.e((String)"MMKVSharedPreferences", (String)("unknown type: " + value.getClass()));
            }
            editor.apply();
        }
    }

    protected List<SharedPreferences.OnSharedPreferenceChangeListener> getOnSharedPreferenceChangeListeners() {
        return this.onSharedPreferenceChangeListeners;
    }

    public Map<String, ?> getAll() {
        MMKV mmkvType = this.getMmkvType();
        String[] allKeys = this.mmkv.allKeys();
        if (allKeys != null && allKeys.length > 0) {
            HashMap<String, String> all = new HashMap<String, String>();
            for (String key : allKeys) {
                int type = mmkvType.getInt(key, -101);
                Object value = null;
                if (type != -101) {
                    switch (type) {
                        case 1: {
                            value = this.mmkv.getInt(key, 0);
                            break;
                        }
                        case 2: {
                            value = this.mmkv.getLong(key, 0L);
                            break;
                        }
                        case 6: {
                            value = this.mmkv.getBoolean(key, false);
                            break;
                        }
                        case 3: {
                            value = this.mmkv.getString(key, null);
                            break;
                        }
                        case 4: {
                            value = this.mmkv.getStringSet(key, null);
                            break;
                        }
                        case 5: {
                            value = Float.valueOf(this.mmkv.getFloat(key, 0.0f));
                        }
                    }
                }
                if (value == null) continue;
                all.put(key, (String)value);
            }
            return all;
        }
        return new HashMap();
    }

    @Nullable
    public String getString(String key, @Nullable String defValue) {
        return this.mmkv.getString(key, defValue);
    }

    @Nullable
    public Set<String> getStringSet(String key, @Nullable Set<String> defValues) {
        return this.mmkv.getStringSet(key, defValues);
    }

    public int getInt(String key, int defValue) {
        return this.mmkv.getInt(key, defValue);
    }

    public long getLong(String key, long defValue) {
        return this.mmkv.getLong(key, defValue);
    }

    public float getFloat(String key, float defValue) {
        return this.mmkv.getFloat(key, defValue);
    }

    public boolean getBoolean(String key, boolean defValue) {
        return this.mmkv.getBoolean(key, defValue);
    }

    public boolean contains(String key) {
        return this.mmkv.contains(key);
    }

    public SharedPreferences.Editor edit() {
        return new MMKVEdit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        MMKVSharedPreferences mMKVSharedPreferences = this;
        synchronized (mMKVSharedPreferences) {
            if (this.onSharedPreferenceChangeListeners == null) {
                this.onSharedPreferenceChangeListeners = new ArrayList<SharedPreferences.OnSharedPreferenceChangeListener>();
            }
            this.onSharedPreferenceChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        MMKVSharedPreferences mMKVSharedPreferences = this;
        synchronized (mMKVSharedPreferences) {
            if (this.onSharedPreferenceChangeListeners != null) {
                this.onSharedPreferenceChangeListeners.remove(listener);
            }
        }
    }

    protected abstract void notifyListener(String var1);

    protected abstract void notifyListener(String[] var1);

    class MMKVEdit
    implements SharedPreferences.Editor {
        private final Map<String, Object> keyValues = new HashMap<String, Object>();
        private boolean isClear;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putString(String key, @Nullable String value) {
            MMKVEdit mMKVEdit = this;
            synchronized (mMKVEdit) {
                this.keyValues.put(key, value);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putStringSet(String key, @Nullable Set<String> values) {
            MMKVEdit mMKVEdit = this;
            synchronized (mMKVEdit) {
                this.keyValues.put(key, values);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putInt(String key, int value) {
            MMKVEdit mMKVEdit = this;
            synchronized (mMKVEdit) {
                this.keyValues.put(key, value);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putLong(String key, long value) {
            MMKVEdit mMKVEdit = this;
            synchronized (mMKVEdit) {
                this.keyValues.put(key, value);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putFloat(String key, float value) {
            MMKVEdit mMKVEdit = this;
            synchronized (mMKVEdit) {
                this.keyValues.put(key, Float.valueOf(value));
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            MMKVEdit mMKVEdit = this;
            synchronized (mMKVEdit) {
                this.keyValues.put(key, value);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor remove(String key) {
            MMKVEdit mMKVEdit = this;
            synchronized (mMKVEdit) {
                this.keyValues.put(key, this);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor clear() {
            MMKVEdit mMKVEdit = this;
            synchronized (mMKVEdit) {
                this.isClear = true;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean commit() {
            MMKVEdit mMKVEdit = this;
            synchronized (mMKVEdit) {
                if (this.isClear) {
                    this.commitClear();
                } else {
                    this.commitUpdate();
                }
            }
            return true;
        }

        private void commitUpdate() {
            MMKV mmkvType = MMKVSharedPreferences.this.getMmkvType();
            for (Map.Entry<String, Object> entry : this.keyValues.entrySet()) {
                Object value = entry.getValue();
                if (value == null) {
                    mmkvType.remove(entry.getKey());
                    MMKVSharedPreferences.this.mmkv.remove(entry.getKey());
                } else if (value instanceof Integer) {
                    if (!mmkvType.contains(entry.getKey())) {
                        mmkvType.encode(entry.getKey(), 1);
                    }
                    MMKVSharedPreferences.this.mmkv.encode(entry.getKey(), ((Integer)value).intValue());
                } else if (value instanceof String) {
                    if (!mmkvType.contains(entry.getKey())) {
                        mmkvType.encode(entry.getKey(), 3);
                    }
                    MMKVSharedPreferences.this.mmkv.encode(entry.getKey(), (String)value);
                } else if (value instanceof Long) {
                    if (!mmkvType.contains(entry.getKey())) {
                        mmkvType.encode(entry.getKey(), 2);
                    }
                    MMKVSharedPreferences.this.mmkv.encode(entry.getKey(), ((Long)value).longValue());
                } else if (value instanceof Float) {
                    if (!mmkvType.contains(entry.getKey())) {
                        mmkvType.encode(entry.getKey(), 5);
                    }
                    MMKVSharedPreferences.this.mmkv.encode(entry.getKey(), ((Float)value).floatValue());
                } else if (value instanceof Boolean) {
                    if (!mmkvType.contains(entry.getKey())) {
                        mmkvType.encode(entry.getKey(), 6);
                    }
                    MMKVSharedPreferences.this.mmkv.encode(entry.getKey(), ((Boolean)value).booleanValue());
                } else if (value instanceof Set) {
                    if (!mmkvType.contains(entry.getKey())) {
                        mmkvType.encode(entry.getKey(), 4);
                    }
                    MMKVSharedPreferences.this.mmkv.encode(entry.getKey(), (Set)value);
                } else if (value instanceof MMKVEdit) {
                    mmkvType.remove(entry.getKey());
                    MMKVSharedPreferences.this.mmkv.remove(entry.getKey());
                }
                MMKVSharedPreferences.this.notifyListener(entry.getKey());
            }
        }

        private void commitClear() {
            String[] allKeys = MMKVSharedPreferences.this.mmkv.allKeys();
            MMKV mmkvType = MMKVSharedPreferences.this.getMmkvType();
            MMKVSharedPreferences.this.mmkv.clear();
            mmkvType.clear();
            if (allKeys != null) {
                MMKVSharedPreferences.this.notifyListener(allKeys);
            }
        }

        public void apply() {
            this.commit();
        }
    }
}

