/*
 * Decompiled with CFR 0.152.
 */
package com.caij.sharedpreferences.mmkv;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.caij.sharedpreferences.mmkv.MMKVSharedPreferences;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class MultiProcessListenerMMKVSharedPreferences
extends MMKVSharedPreferences {
    private static final String ACTION_ENTRY_UPDATE = "mmkv.multiprocess.entry.update";
    private static final String KEY_NAME = "key_name";
    private static final String KEY_NAMES = "key_names";
    private final Context app;
    private final String action;

    public MultiProcessListenerMMKVSharedPreferences(Context context, String name, int mode) {
        super(name, mode);
        this.app = context.getApplicationContext();
        this.action = "mmkv.multiprocess.entry.update." + name;
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(this.action);
        this.app.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                ArrayList keyNames;
                String keyName = intent.getStringExtra(MultiProcessListenerMMKVSharedPreferences.KEY_NAME);
                if (!TextUtils.isEmpty((CharSequence)keyName)) {
                    MultiProcessListenerMMKVSharedPreferences.this.notifyListenerInner(keyName);
                }
                if ((keyNames = intent.getStringArrayListExtra(MultiProcessListenerMMKVSharedPreferences.KEY_NAMES)) != null && !keyNames.isEmpty()) {
                    MultiProcessListenerMMKVSharedPreferences.this.notifyListenerInner(keyNames);
                }
            }
        }, intentFilter);
    }

    @Override
    protected void notifyListener(String key) {
        Intent intent = new Intent(this.action);
        intent.putExtra(KEY_NAME, key);
        this.app.sendBroadcast(intent);
    }

    @Override
    protected void notifyListener(String[] allKeys) {
        Intent intent = new Intent(this.action);
        intent.putStringArrayListExtra(KEY_NAMES, new ArrayList<String>(Arrays.asList(allKeys)));
        this.app.sendBroadcast(intent);
    }

    protected void notifyListenerInner(String key) {
        List<SharedPreferences.OnSharedPreferenceChangeListener> onSharedPreferenceChangeListeners = this.getOnSharedPreferenceChangeListeners();
        if (onSharedPreferenceChangeListeners != null && !onSharedPreferenceChangeListeners.isEmpty()) {
            for (SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener : onSharedPreferenceChangeListeners) {
                onSharedPreferenceChangeListener.onSharedPreferenceChanged((SharedPreferences)this, key);
            }
        }
    }

    protected void notifyListenerInner(Collection<String> allKeys) {
        for (String key : allKeys) {
            this.notifyListener(key);
        }
    }
}

