/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.ContainerCacheManagerPeerProvider;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiCacheManagerPeerProvider
extends ContainerCacheManagerPeerProvider {
    private static final Logger LOG = LoggerFactory.getLogger((String)ApiCacheManagerPeerProvider.class.getName());
    private String serviceName;
    private String apiUrl;
    private Executor http;
    private ObjectMapper json;

    public ApiCacheManagerPeerProvider(CacheManager cacheManager, String serviceName, String apiUrl) {
        super(cacheManager);
        this.serviceName = serviceName;
        this.apiUrl = apiUrl;
    }

    @Override
    public final void init() throws CacheException {
        LOG.info("Initializing DockerCacheManagerPeerProvider with service name : {}", (Object)this.serviceName);
        try {
            super.init();
            this.http = Executor.newInstance();
            this.json = new ObjectMapper();
        }
        catch (Exception exception) {
            LOG.error("Error getting docker client. Error was: " + exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public List<String> getOtherContainerAdresses() {
        LOG.debug("About to lookup container instance of {}", (Object)this.serviceName);
        List<String> ips = Collections.emptyList();
        try {
            ips = ((List)this.http.execute(Request.Get((String)(this.apiUrl + "/" + this.serviceName))).handleResponse(response -> (List)((Map)this.json.readValue(response.getEntity().getContent(), Map.class)).get(this.serviceName))).stream().filter(ip -> !this.getHostAdress().equals(ip)).collect(Collectors.toList());
            LOG.debug("Found other container instance of {} : {}", (Object)this.serviceName, ips);
        }
        catch (IOException e) {
            LOG.warn("Unable to get service instance of {} with api {}", new Object[]{this.serviceName, this.apiUrl, e});
        }
        return ips;
    }

    public String mapHostNameToAdress(String hostName) {
        return InetAddress.getByName(hostName).getHostAddress();
    }

    @Override
    public final void dispose() {
        super.dispose();
    }
}

