/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.IOException;
import java.net.InetAddress;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.MulticastKeepaliveHeartbeatSender;
import net.sf.ehcache.distribution.RMICacheManagerPeerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContainerCacheManagerPeerProvider
extends RMICacheManagerPeerProvider {
    protected static final int SHORT_DELAY = 100;
    private static final Logger LOG = LoggerFactory.getLogger((String)ContainerCacheManagerPeerProvider.class.getName());
    private ScheduledExecutorService executor;
    private String hostName;
    private String hostAdress;

    public ContainerCacheManagerPeerProvider(CacheManager cacheManager) {
        super(cacheManager);
    }

    public void init() throws CacheException {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
            this.hostAdress = InetAddress.getLocalHost().getHostAddress();
            LOG.debug("Initializing {} : hostName={}, hostAdress={}", new Object[]{((Object)((Object)this)).getClass(), this.hostName, this.hostAdress});
            this.executor = Executors.newScheduledThreadPool(1);
            this.executor.scheduleWithFixedDelay(this::registerDockerPeers, 1000L, 1000L, TimeUnit.MILLISECONDS);
            LOG.debug("Registered docker ehcache peer provider task in executor");
        }
        catch (Exception exception) {
            LOG.error("Error getting docker client. Error was: " + exception.getMessage(), (Throwable)exception);
        }
    }

    private void registerDockerPeers() {
        LOG.debug("About to register Docker CachePeer for host {}", (Object)this.hostName);
        CacheManagerPeerListener cacheManagerPeerListener = this.cacheManager.getCachePeerListener("RMI");
        if (cacheManagerPeerListener == null) {
            LOG.warn("The RMICacheManagerPeerListener is missing. You need to configure a cacheManagerPeerListenerFactory with class=\"net.sf.ehcache.distribution.RMICacheManagerPeerListenerFactory\" in ehcache.xml.");
            return;
        }
        List<String> otherContainerNames = this.getOtherContainerAdresses();
        List localCachePeers = cacheManagerPeerListener.getBoundCachePeers();
        LOG.debug("localCachePeers are {}", (Object)localCachePeers);
        localCachePeers.stream().map(p -> {
            try {
                return p.getUrl();
            }
            catch (RemoteException e) {
                return null;
            }
        }).filter(url -> url != null).forEach(url -> {
            LOG.debug("About to register docker cachePeers for local url {}", url);
            otherContainerNames.forEach(otherHosts -> {
                String otherUrl = "rmi:" + url.replace(this.hostAdress, (CharSequence)otherHosts);
                if (!this.peerUrls.containsKey(otherUrl)) {
                    LOG.debug("Registering target docker CachePeer {}", (Object)otherUrl);
                    this.registerPeer(otherUrl);
                }
            });
        });
    }

    public abstract List<String> getOtherContainerAdresses();

    public String getHostAdress() {
        return this.hostAdress;
    }

    public String getHostName() {
        return this.hostName;
    }

    public final void registerPeer(String rmiUrl) {
        try {
            CachePeerEntry cachePeerEntry = (CachePeerEntry)this.peerUrls.get(rmiUrl);
            if (cachePeerEntry == null || this.stale(cachePeerEntry.date)) {
                if (cachePeerEntry == null) {
                    LOG.info("Registering new CachePeer for {}", (Object)rmiUrl);
                }
                CachePeer cachePeer = this.lookupRemoteCachePeer(rmiUrl);
                cachePeerEntry = new CachePeerEntry(cachePeer, new Date());
                this.peerUrls.put(rmiUrl, cachePeerEntry);
            } else {
                cachePeerEntry.date = new Date();
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to lookup remote cache peer for {}. Removing from peer list. Cause was: ", (Object)rmiUrl, (Object)e.getMessage());
            this.unregisterPeer(rmiUrl);
        }
        catch (NotBoundException e) {
            this.peerUrls.remove(rmiUrl);
            LOG.warn("Unable to lookup remote cache peer for {}. Removing from peer list. Cause was: {}", (Object)rmiUrl, (Object)e.getMessage());
        }
        catch (Throwable t) {
            LOG.error("Unable to lookup remote cache peer for " + rmiUrl + ". Cause was not due to an IOException or NotBoundException which will occur in normal operation: " + t.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized List listRemoteCachePeers(Ehcache cache) throws CacheException {
        ArrayList<CachePeer> remoteCachePeers = new ArrayList<CachePeer>();
        ArrayList<String> staleList = new ArrayList<String>();
        Map map = this.peerUrls;
        synchronized (map) {
            for (String rmiUrl : this.peerUrls.keySet()) {
                String rmiUrlCacheName = ContainerCacheManagerPeerProvider.extractCacheName((String)rmiUrl);
                try {
                    if (!rmiUrlCacheName.equals(cache.getName())) continue;
                    CachePeerEntry cachePeerEntry = (CachePeerEntry)this.peerUrls.get(rmiUrl);
                    Date date = cachePeerEntry.date;
                    if (!this.stale(date)) {
                        CachePeer cachePeer = cachePeerEntry.cachePeer;
                        remoteCachePeers.add(cachePeer);
                        continue;
                    }
                    LOG.debug("rmiUrl is stale. Either the remote peer is shutdown or the network connectivity has been interrupted. Will be removed from list of remote cache peers", (Object)rmiUrl);
                    staleList.add(rmiUrl);
                }
                catch (Exception exception) {
                    LOG.error(exception.getMessage(), (Throwable)exception);
                    throw new CacheException("Unable to list remote cache peers. Error was " + exception.getMessage());
                }
            }
            for (int i = 0; i < staleList.size(); ++i) {
                String rmiUrl;
                rmiUrl = (String)staleList.get(i);
                this.peerUrls.remove(rmiUrl);
            }
        }
        return remoteCachePeers;
    }

    public void dispose() {
        this.executor.shutdown();
    }

    public long getTimeForClusterToForm() {
        return 2100L;
    }

    protected long getStaleTime() {
        return MulticastKeepaliveHeartbeatSender.getHeartBeatStaleTime();
    }

    protected final boolean stale(Date date) {
        long now = System.currentTimeMillis();
        return date.getTime() < now - this.getStaleTime();
    }

    protected static final class CachePeerEntry {
        private final CachePeer cachePeer;
        private Date date;

        public CachePeerEntry(CachePeer cachePeer, Date date) {
            this.cachePeer = cachePeer;
            this.date = date;
        }

        public final CachePeer getCachePeer() {
            return this.cachePeer;
        }

        public final Date getDate() {
            return this.date;
        }
    }
}

