/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.ListTasksCmd;
import com.github.dockerjava.api.model.TaskState;
import com.github.dockerjava.core.DockerClientBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.ContainerCacheManagerPeerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerCacheManagerPeerProvider
extends ContainerCacheManagerPeerProvider {
    private static final Logger LOG = LoggerFactory.getLogger((String)DockerCacheManagerPeerProvider.class.getName());
    private DockerClient dockerClient;
    private String serviceName;

    public DockerCacheManagerPeerProvider(CacheManager cacheManager, String serviceName) {
        super(cacheManager);
        this.serviceName = serviceName;
    }

    @Override
    public final void init() throws CacheException {
        LOG.info("Initializing DockerCacheManagerPeerProvider with service name : {}", (Object)this.serviceName);
        try {
            super.init();
            this.dockerClient = DockerClientBuilder.getInstance().build();
            this.dockerClient.pingCmd().exec();
        }
        catch (Exception exception) {
            LOG.error("Error getting docker client. Error was: " + exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public List<String> getOtherContainerAdresses() {
        LOG.debug("About to lookup container instance of {}", (Object)this.serviceName);
        ListTasksCmd cmd = this.dockerClient.listTasksCmd().withServiceFilter(new String[]{this.serviceName});
        List tasks = cmd.exec();
        List<String> ips = tasks.stream().filter(t -> t.getStatus().getState().equals((Object)TaskState.RUNNING)).map(t -> t.getStatus().getContainerStatus().getContainerID().substring(0, 12)).filter(hostName -> !this.getHostName().equals(hostName)).map(this::mapHostNameToAdress).collect(Collectors.toList());
        LOG.debug("Found other container instance of {} : {}", (Object)this.serviceName, ips);
        return ips;
    }

    public String mapHostNameToAdress(String hostName) {
        return InetAddress.getByName(hostName).getHostAddress();
    }

    @Override
    public final void dispose() {
        super.dispose();
        try {
            this.dockerClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

