/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.util.Properties;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.ApiCacheManagerPeerProvider;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CacheManagerPeerProviderFactory;
import net.sf.ehcache.distribution.DockerCacheManagerPeerProvider;
import net.sf.ehcache.distribution.K8SCacheManagerPeerProvider;
import net.sf.ehcache.util.PropertyUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerCacheManagerPeerProviderFactory
extends CacheManagerPeerProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)DockerCacheManagerPeerProviderFactory.class.getName());

    public CacheManagerPeerProvider createCachePeerProvider(CacheManager cacheManager, Properties properties) {
        String dockerSwarmServiceName = PropertyUtil.extractAndLogProperty((String)"dockerSwarmServiceName", (Properties)properties);
        String apiServiceName = PropertyUtil.extractAndLogProperty((String)"apiServiceName", (Properties)properties);
        String apiUrl = PropertyUtil.extractAndLogProperty((String)"apiUrl", (Properties)properties);
        String k8sUrl = PropertyUtil.extractAndLogProperty((String)"k8sUrl", (Properties)properties);
        String k8sUsername = PropertyUtil.extractAndLogProperty((String)"k8sUsername", (Properties)properties);
        String k8sPassword = PropertyUtil.extractAndLogProperty((String)"k8sPassword", (Properties)properties);
        String k8sNamespace = PropertyUtil.extractAndLogProperty((String)"k8sNamespace", (Properties)properties);
        String k8sAppSelector = PropertyUtil.extractAndLogProperty((String)"k8sAppSelector", (Properties)properties);
        String k8sToken = PropertyUtil.extractAndLogProperty((String)"k8sToken", (Properties)properties);
        String k8sValidateSSL = PropertyUtil.extractAndLogProperty((String)"k8sValidateSSL", (Properties)properties);
        if (StringUtils.isNotBlank((CharSequence)apiServiceName) && StringUtils.isNotBlank((CharSequence)apiServiceName)) {
            return new ApiCacheManagerPeerProvider(cacheManager, apiServiceName, apiUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)dockerSwarmServiceName)) {
            return new DockerCacheManagerPeerProvider(cacheManager, dockerSwarmServiceName);
        }
        if (StringUtils.isNotBlank((CharSequence)k8sAppSelector)) {
            boolean validateSSL = StringUtils.isNotBlank((CharSequence)k8sValidateSSL) ? Boolean.parseBoolean(k8sValidateSSL) : true;
            return new K8SCacheManagerPeerProvider(cacheManager, k8sUrl, k8sToken, k8sUsername, k8sPassword, k8sNamespace, k8sAppSelector, validateSSL);
        }
        LOG.error("No dockerSwarmServiceName nor k8sAppSelector configured, no CacheManagerPeerProvider can be created");
        return null;
    }
}

