/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import com.google.common.collect.Lists;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.util.Config;
import java.net.InetAddress;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.ContainerCacheManagerPeerProvider;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8SCacheManagerPeerProvider
extends ContainerCacheManagerPeerProvider {
    private static final Logger LOG = LoggerFactory.getLogger((String)K8SCacheManagerPeerProvider.class.getName());
    private ApiClient client;
    private String k8sUrl;
    private String k8sToken;
    private String k8sUsername;
    private String k8sPassword;
    private String k8sNamespace;
    private String k8sAppSelector;
    private boolean validateSSL;

    public K8SCacheManagerPeerProvider(CacheManager cacheManager, String k8sAppSelector) {
        super(cacheManager);
        this.k8sAppSelector = k8sAppSelector;
    }

    public K8SCacheManagerPeerProvider(CacheManager cacheManager, String k8sUrl, String k8sToken, String k8sUsername, String k8sPassword, String k8sNamespace, String k8sAppSelector, boolean validateSSL) {
        this(cacheManager, k8sAppSelector);
        this.k8sUrl = k8sUrl;
        this.k8sToken = k8sToken;
        this.k8sUsername = k8sUsername;
        this.k8sPassword = k8sPassword;
        this.validateSSL = validateSSL;
        this.k8sNamespace = this.orDefault(k8sNamespace, "default");
    }

    private String orDefault(String val, String def) {
        return val != null && val.length() > 0 ? val : def;
    }

    @Override
    public final void init() throws CacheException {
        try {
            super.init();
            this.client = StringUtils.isNotBlank((CharSequence)this.k8sUrl) && StringUtils.isNotBlank((CharSequence)this.k8sUsername) ? Config.fromUserPassword((String)this.k8sUrl, (String)this.k8sUsername, (String)this.k8sPassword, (boolean)this.validateSSL) : (StringUtils.isNotBlank((CharSequence)this.k8sUrl) && StringUtils.isNotBlank((CharSequence)this.k8sToken) ? Config.fromToken((String)this.k8sUrl, (String)this.k8sToken, (boolean)this.validateSSL) : (StringUtils.isNotBlank((CharSequence)this.k8sUrl) ? Config.fromUrl((String)this.k8sUrl, (boolean)this.validateSSL) : Config.defaultClient()));
        }
        catch (Exception exception) {
            LOG.error("Error getting docker client. Error was: " + exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public List<String> getOtherContainerAdresses() {
        CoreV1Api api = new CoreV1Api(this.client);
        try {
            V1PodList items = api.listNamespacedPod(this.k8sNamespace, null, null, null, this.k8sAppSelector, null, null, null, null, Integer.valueOf(10), Boolean.valueOf(false));
            List<String> serviceInstances = items.getItems().stream().map(pod -> pod.getStatus().getPodIP()).map(ips -> {
                InetAddress inet = null;
                try {
                    inet = InetAddress.getByName(ips);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return inet;
            }).filter(c -> !this.getHostAdress().equals(c.getHostAddress())).map(c -> c.getHostAddress()).collect(Collectors.toList());
            LOG.debug("Found other container instance of {} : {}", (Object)this.k8sAppSelector, serviceInstances);
            return serviceInstances;
        }
        catch (Exception e) {
            LOG.error("Failed to retrieve pods list ", (Throwable)e);
            return Lists.newArrayList();
        }
    }
}

