/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.address.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import rest.koios.client.backend.api.address.AddressService;
import rest.koios.client.backend.api.address.api.AddressApi;
import rest.koios.client.backend.api.address.model.AddressAsset;
import rest.koios.client.backend.api.address.model.AddressInfo;
import rest.koios.client.backend.api.address.model.AddressUtxo;
import rest.koios.client.backend.api.base.BaseService;
import rest.koios.client.backend.api.base.Result;
import rest.koios.client.backend.api.base.exception.ApiException;
import rest.koios.client.backend.api.common.TxHash;
import rest.koios.client.backend.factory.options.Options;
import rest.koios.client.backend.factory.options.SortType;
import retrofit2.Call;
import retrofit2.Response;

public class AddressServiceImpl
extends BaseService
implements AddressService {
    private final AddressApi addressApi = (AddressApi)this.getRetrofit().create(AddressApi.class);

    public AddressServiceImpl(BaseService baseService) {
        super(baseService);
    }

    @Override
    public Result<AddressInfo> getAddressInformation(String address) throws ApiException {
        return this.getAddressInformation(List.of(address), SortType.DESC, null);
    }

    @Override
    public Result<AddressInfo> getAddressInformation(List<String> addressList, SortType utxoSortType, Options options) throws ApiException {
        for (String address : addressList) {
            this.validateBech32(address);
        }
        Call<List<AddressInfo>> call = this.addressApi.getAddressInformation(this.buildBody("_addresses", addressList, null), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            Result<AddressInfo> result = this.processResponseGetOne(response);
            if (result.isSuccessful()) {
                if (utxoSortType == SortType.DESC) {
                    result.getValue().setUtxoSet(new TreeSet<AddressUtxo>(result.getValue().getUtxoSet()).descendingSet());
                } else {
                    result.getValue().setUtxoSet(new TreeSet<AddressUtxo>(result.getValue().getUtxoSet()));
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<TxHash>> getAddressTransactions(List<String> addressList, Options options) throws ApiException {
        return this.getAddressTransactions(addressList, 0, options);
    }

    @Override
    public Result<List<TxHash>> getAddressTransactions(List<String> addressList, Integer afterBlockHeight, Options options) throws ApiException {
        if (afterBlockHeight < 0) {
            throw new ApiException("Non Positive \"afterBlockHeight\" Value");
        }
        for (String address : addressList) {
            this.validateBech32(address);
        }
        Call<List<TxHash>> call = this.addressApi.getAddressTransactions(this.buildBody("_addresses", addressList, afterBlockHeight), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<AddressAsset>> getAddressAssets(List<String> addressList, Options options) throws ApiException {
        for (String address : addressList) {
            this.validateBech32(address);
        }
        Call<List<AddressAsset>> call = this.addressApi.getAddressAssets(this.buildBody("_addresses", addressList, null), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<TxHash>> getTransactionsByPaymentCredentials(List<String> paymentCredentialsList, Options options) throws ApiException {
        return this.getTransactionsByPaymentCredentials(paymentCredentialsList, 0, options);
    }

    @Override
    public Result<List<TxHash>> getTransactionsByPaymentCredentials(List<String> paymentCredentialsList, Integer afterBlockHeight, Options options) throws ApiException {
        if (afterBlockHeight < 0) {
            throw new ApiException("Non Positive \"afterBlockHeight\" Value");
        }
        for (String paymentCredentials : paymentCredentialsList) {
            this.validateHexFormat(paymentCredentials);
        }
        Call<List<TxHash>> call = this.addressApi.getTransactionsByPaymentCredentials(this.buildBody("_payment_credentials", paymentCredentialsList, afterBlockHeight), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    private Map<String, Object> buildBody(String arrayObjString, List<String> list, Integer afterBlockHeight) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put(arrayObjString, list);
        if (afterBlockHeight != null) {
            bodyMap.put("_after_block_height", afterBlockHeight);
        }
        return bodyMap;
    }
}

