/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.base;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.Refill;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rest.koios.client.backend.api.base.Result;
import rest.koios.client.backend.api.base.exception.ApiException;
import rest.koios.client.backend.factory.options.Options;
import rest.koios.client.utils.Bech32Util;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class BaseService {
    private static final Logger log = LoggerFactory.getLogger(BaseService.class);
    private final Retrofit retrofit;
    private final Bucket bucket;
    private int retriesCount = 5;

    public BaseService(BaseService baseService) {
        this.retrofit = baseService.getRetrofit();
        this.bucket = baseService.getBucket();
        this.retriesCount = baseService.getRetriesCount();
    }

    public BaseService(String baseUrl) {
        OkHttpClient okHttpClient;
        this.bucket = Bucket.builder().addLimit(Bandwidth.classic((long)100L, (Refill)Refill.intervally((long)100L, (Duration)Duration.ofSeconds(10L)))).build();
        int readTimeoutSec = this.getReadTimeoutSec();
        log.info("Set Read Timeout to {} Seconds", (Object)readTimeoutSec);
        int connectTimeoutSec = this.getConnectTimeoutSec();
        log.info("Set Connect Timeout to {} Seconds", (Object)connectTimeoutSec);
        boolean logging = Boolean.parseBoolean(System.getenv("KOIOS_JAVA_LIB_LOGGING"));
        if (logging) {
            HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
            interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            okHttpClient = new OkHttpClient.Builder().readTimeout((long)readTimeoutSec, TimeUnit.SECONDS).connectTimeout((long)connectTimeoutSec, TimeUnit.SECONDS).addInterceptor((Interceptor)interceptor).build();
        } else {
            okHttpClient = new OkHttpClient.Builder().readTimeout((long)readTimeoutSec, TimeUnit.SECONDS).connectTimeout((long)connectTimeoutSec, TimeUnit.SECONDS).build();
        }
        String strRetries = System.getenv("KOIOS_JAVA_LIB_RETRIES_COUNT");
        if (strRetries != null && !strRetries.isEmpty()) {
            this.retriesCount = Math.max(Integer.parseInt(strRetries), 1);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.retrofit = new Retrofit.Builder().baseUrl(baseUrl).client(okHttpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper)).build();
    }

    private int getReadTimeoutSec() {
        int readTimeoutSec = 60;
        String strReadTimeoutSec = System.getenv("KOIOS_JAVA_LIB_READ_TIMEOUT_SEC");
        if (strReadTimeoutSec != null && !strReadTimeoutSec.isEmpty()) {
            readTimeoutSec = Integer.parseInt(strReadTimeoutSec);
        }
        return readTimeoutSec >= 1 ? readTimeoutSec : 60;
    }

    private int getConnectTimeoutSec() {
        int connectTimeoutSec = 60;
        String strReadTimeoutSec = System.getenv("KOIOS_JAVA_LIB_CONNECT_TIMEOUT_SEC");
        if (strReadTimeoutSec != null && !strReadTimeoutSec.isEmpty()) {
            connectTimeoutSec = Integer.parseInt(strReadTimeoutSec);
        }
        return connectTimeoutSec >= 1 ? connectTimeoutSec : 60;
    }

    protected <T> Result<T> processResponseGetOne(Response<List<T>> response) throws IOException {
        if (response.isSuccessful()) {
            if (response.body() != null && !((List)response.body()).isEmpty()) {
                return Result.builder().successful(true).response(response.toString()).value(((List)response.body()).get(0)).code(response.code()).build();
            }
            if (response.body() != null) {
                return Result.builder().successful(false).response("Response Body is Empty").code(404).build();
            }
            return Result.builder().successful(false).response("Response Body is Invalid").code(500).build();
        }
        return Result.builder().successful(false).response(Objects.requireNonNull(response.errorBody()).string()).code(response.code()).build();
    }

    protected <T> Result<T> processResponse(Response<T> response) throws IOException {
        if (response.isSuccessful()) {
            return Result.builder().successful(true).response(response.toString()).value(response.body()).code(response.code()).build();
        }
        return Result.builder().successful(false).response(Objects.requireNonNull(response.errorBody()).string()).code(response.code()).build();
    }

    public Response<Object> execute(Call<?> call) throws ApiException, IOException {
        if (this.getBucket().tryConsume(1L)) {
            int tryCount = 1;
            while (tryCount <= this.retriesCount) {
                try {
                    Response response = call.clone().execute();
                    if (response.code() != 504) {
                        return response;
                    }
                    log.warn(response.message());
                    tryCount = this.retry(tryCount);
                }
                catch (SocketTimeoutException e) {
                    log.warn(e.getMessage());
                    tryCount = this.retry(tryCount);
                }
            }
            throw new ApiException("Retry Count Exceeded.");
        }
        throw new ApiException("HTTP Error (429) - Too Many Requests.");
    }

    private int retry(int tryCount) {
        if (++tryCount < this.retriesCount) {
            log.info("Retrying... (" + tryCount + "/" + this.retriesCount + ")");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
        return tryCount;
    }

    protected void validateEpoch(Integer epochNo) throws ApiException {
        if (epochNo == null) {
            throw new ApiException("Null Value for \"epochNo\"");
        }
        if (epochNo < 0) {
            throw new ApiException("Non Positive \"epochNo\" Value");
        }
    }

    protected void validateBech32(String bech32) throws ApiException {
        if (!Bech32Util.isValid(bech32)) {
            throw new ApiException("Invalid Bech32 Format");
        }
    }

    protected void validateHexFormat(String hex) throws ApiException {
        if (!hex.matches("^[\\da-fA-F]+$")) {
            throw new ApiException("Invalid Hexadecimal String Format");
        }
    }

    protected Map<String, String> optionsToParamMap(Options options) {
        Map<String, String> paramsMap = Collections.emptyMap();
        if (options != null && !options.getOptions().isEmpty()) {
            paramsMap = options.toMap();
        }
        return paramsMap;
    }

    public Retrofit getRetrofit() {
        return this.retrofit;
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    public int getRetriesCount() {
        return this.retriesCount;
    }
}

