/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.base;

public class Result<T> {
    boolean successful;
    String response;
    int code;
    T value;

    Result(boolean successful, String response, int code, T value) {
        this.successful = successful;
        this.response = response;
        this.code = code;
        this.value = value;
    }

    public static <T> ResultBuilder<T> builder() {
        return new ResultBuilder();
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public String getResponse() {
        return this.response;
    }

    public int getCode() {
        return this.code;
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        return "Result(successful=" + this.isSuccessful() + ", response=" + this.getResponse() + ", code=" + this.getCode() + ", value=" + this.getValue() + ")";
    }

    public static class ResultBuilder<T> {
        private boolean successful;
        private String response;
        private int code;
        private T value;

        ResultBuilder() {
        }

        public ResultBuilder<T> successful(boolean successful) {
            this.successful = successful;
            return this;
        }

        public ResultBuilder<T> response(String response) {
            this.response = response;
            return this;
        }

        public ResultBuilder<T> code(int code) {
            this.code = code;
            return this;
        }

        public ResultBuilder<T> value(T value) {
            this.value = value;
            return this;
        }

        public Result<T> build() {
            return new Result<T>(this.successful, this.response, this.code, this.value);
        }

        public String toString() {
            return "Result.ResultBuilder(successful=" + this.successful + ", response=" + this.response + ", code=" + this.code + ", value=" + this.value + ")";
        }
    }
}

