/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.factory.options.filters;

import rest.koios.client.backend.factory.options.Option;
import rest.koios.client.backend.factory.options.OptionType;
import rest.koios.client.backend.factory.options.filters.FilterType;

public class Filter
extends Option {
    private final FilterType filterType;
    private final String field;
    private final String value;

    public Filter(String field, FilterType filterType, String value) {
        super(OptionType.FILTER);
        this.filterType = filterType;
        this.field = field;
        this.value = value;
    }

    public static Filter of(String field, FilterType filterType, String value) {
        return new Filter(field, filterType, value);
    }

    @Override
    public String getOptionTypeValue() {
        return this.field;
    }

    @Override
    public String getValue() {
        return this.filterType.name().toLowerCase() + "." + this.value;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public String getField() {
        return this.field;
    }
}

