/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.utils;

import org.bouncycastle.util.Arrays;
import rest.koios.client.utils.Tuple;

public class Bech32Util {
    private static final int TotalMaxLength = 108;
    private static final int CheckSumSize = 6;
    private static final int HrpMinLength = 1;
    private static final int HrpMaxLength = 83;
    private static final int HrpMinValue = 33;
    private static final int HrpMaxValue = 126;
    private static final char Separator = '1';
    private static final String B32Chars = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";

    public static boolean isValid(String bech32EncodedString) {
        if (!Bech32Util.hasValidChars(bech32EncodedString)) {
            return false;
        }
        Tuple<String, byte[]> data = Bech32Util.bech32Decode(bech32EncodedString);
        if (((byte[])data._2).length < 6) {
            return false;
        }
        return Bech32Util.verifyChecksum((String)data._1, (byte[])data._2);
    }

    public static boolean hasValidChars(String bech32EncodedString) {
        if (bech32EncodedString == null || bech32EncodedString.isEmpty() || bech32EncodedString.length() > 108) {
            return false;
        }
        if (!bech32EncodedString.toLowerCase().equals(bech32EncodedString) && !bech32EncodedString.toUpperCase().equals(bech32EncodedString)) {
            return false;
        }
        int sepIndex = bech32EncodedString.lastIndexOf(49);
        if (sepIndex == -1) {
            return false;
        }
        String hrp = bech32EncodedString.substring(0, sepIndex);
        if (!Bech32Util.isValidHrp(hrp)) {
            return false;
        }
        String data = bech32EncodedString.substring(sepIndex + 1);
        return data.length() >= 6 && data.chars().noneMatch(x -> B32Chars.indexOf(x) == -1);
    }

    private static boolean isValidHrp(String hrp) {
        return hrp != null && hrp.trim().length() > 0 && hrp.length() >= 1 && hrp.length() < 83 && hrp.chars().allMatch(character -> character >= 33 && character <= 126);
    }

    private static int polymod(byte[] values) {
        int c = 1;
        for (byte v_i : values) {
            int c0 = c >>> 25 & 0xFF;
            c = (c & 0x1FFFFFF) << 5 ^ v_i & 0xFF;
            if ((c0 & 1) != 0) {
                c ^= 0x3B6A57B2;
            }
            if ((c0 & 2) != 0) {
                c ^= 0x26508E6D;
            }
            if ((c0 & 4) != 0) {
                c ^= 0x1EA119FA;
            }
            if ((c0 & 8) != 0) {
                c ^= 0x3D4233DD;
            }
            if ((c0 & 0x10) == 0) continue;
            c ^= 0x2A1462B3;
        }
        return c;
    }

    private static byte[] expandHrp(String hrp) {
        byte[] result = new byte[2 * hrp.length() + 1];
        for (int i = 0; i < hrp.length(); ++i) {
            result[i] = (byte)(hrp.charAt(i) >> 5);
            result[i + hrp.length() + 1] = (byte)(hrp.charAt(i) & 0x1F);
        }
        return result;
    }

    private static boolean verifyChecksum(String hrp, byte[] data) {
        byte[] temp = Arrays.concatenate((byte[])Bech32Util.expandHrp(hrp), (byte[])data);
        return Bech32Util.polymod(temp) == 1;
    }

    private static Tuple<String, byte[]> bech32Decode(String bech32EncodedString) {
        bech32EncodedString = bech32EncodedString.toLowerCase();
        int separatorIndex = bech32EncodedString.lastIndexOf(49);
        String hrp = bech32EncodedString.substring(0, separatorIndex);
        String data = bech32EncodedString.substring(separatorIndex + 1);
        byte[] b32Arr = new byte[data.length()];
        for (int i = 0; i < data.length(); ++i) {
            b32Arr[i] = (byte)B32Chars.indexOf(data.charAt(i));
        }
        return new Tuple<String, byte[]>(hrp, b32Arr);
    }
}

