/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.asset.impl;

import java.io.IOException;
import java.util.List;
import rest.koios.client.backend.api.asset.AssetService;
import rest.koios.client.backend.api.asset.api.AssetApi;
import rest.koios.client.backend.api.asset.model.Asset;
import rest.koios.client.backend.api.asset.model.AssetAddress;
import rest.koios.client.backend.api.asset.model.AssetHistory;
import rest.koios.client.backend.api.asset.model.AssetInformation;
import rest.koios.client.backend.api.asset.model.AssetSummary;
import rest.koios.client.backend.api.asset.model.PolicyAsset;
import rest.koios.client.backend.api.base.BaseService;
import rest.koios.client.backend.api.base.Result;
import rest.koios.client.backend.api.base.exception.ApiException;
import rest.koios.client.backend.api.common.TxHash;
import rest.koios.client.backend.factory.options.Options;
import retrofit2.Call;
import retrofit2.Response;

public class AssetServiceImpl
extends BaseService
implements AssetService {
    private final AssetApi assetApi = (AssetApi)this.getRetrofit().create(AssetApi.class);

    public AssetServiceImpl(BaseService baseService) {
        super(baseService);
    }

    @Override
    public Result<List<Asset>> getAssetList(Options options) throws ApiException {
        Call<List<Asset>> call = this.assetApi.getAssetList(this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<AssetAddress>> getAssetsAddressList(String assetPolicy, String assetName, Options options) throws ApiException {
        this.validateHexFormat(assetPolicy);
        this.validateHexFormat(assetName);
        Call<List<AssetAddress>> call = this.assetApi.getAssetsAddressList(assetPolicy, assetName, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<AssetInformation> getAssetInformation(String assetPolicy, String assetName) throws ApiException {
        this.validateHexFormat(assetPolicy);
        this.validateHexFormat(assetName);
        Call<List<AssetInformation>> call = this.assetApi.getAssetInformation(assetPolicy, assetName);
        try {
            Response<Object> response = this.execute(call);
            return this.processResponseGetOne(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<AssetHistory>> getAssetHistory(String assetPolicy, String assetName, Options options) throws ApiException {
        this.validateHexFormat(assetPolicy);
        this.validateHexFormat(assetName);
        Call<List<AssetHistory>> call = this.assetApi.getAssetHistory(assetPolicy, assetName, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<PolicyAsset>> getAssetPolicyInformation(String assetPolicy, Options options) throws ApiException {
        this.validateHexFormat(assetPolicy);
        Call<List<PolicyAsset>> call = this.assetApi.getAssetPolicyInformation(assetPolicy, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<AssetSummary> getAssetSummary(String assetPolicy, String assetName) throws ApiException {
        this.validateHexFormat(assetPolicy);
        this.validateHexFormat(assetName);
        Call<List<AssetSummary>> call = this.assetApi.getAssetSummary(assetPolicy, assetName);
        try {
            Response<Object> response = this.execute(call);
            return this.processResponseGetOne(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<TxHash>> getAssetTransactions(String assetPolicy, String assetName, Options options) throws ApiException {
        return this.getAssetTransactions(assetPolicy, assetName, 0, false, options);
    }

    @Override
    public Result<List<TxHash>> getAssetTransactions(String assetPolicy, String assetName, Integer afterBlockHeight, boolean history, Options options) throws ApiException {
        this.validateHexFormat(assetPolicy);
        this.validateHexFormat(assetName);
        Call<List<TxHash>> call = this.assetApi.getAssetTransactionHistory(assetPolicy, assetName, afterBlockHeight, history, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }
}

