/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.pool.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rest.koios.client.backend.api.base.BaseService;
import rest.koios.client.backend.api.base.Result;
import rest.koios.client.backend.api.base.exception.ApiException;
import rest.koios.client.backend.api.pool.PoolService;
import rest.koios.client.backend.api.pool.api.PoolApi;
import rest.koios.client.backend.api.pool.model.Pool;
import rest.koios.client.backend.api.pool.model.PoolBlock;
import rest.koios.client.backend.api.pool.model.PoolDelegator;
import rest.koios.client.backend.api.pool.model.PoolDelegatorHistory;
import rest.koios.client.backend.api.pool.model.PoolHistory;
import rest.koios.client.backend.api.pool.model.PoolInfo;
import rest.koios.client.backend.api.pool.model.PoolMetadata;
import rest.koios.client.backend.api.pool.model.PoolRelay;
import rest.koios.client.backend.api.pool.model.PoolStakeSnapshot;
import rest.koios.client.backend.api.pool.model.PoolUpdate;
import rest.koios.client.backend.factory.options.Options;
import retrofit2.Call;
import retrofit2.Response;

public class PoolServiceImpl
extends BaseService
implements PoolService {
    private final PoolApi poolApi = (PoolApi)this.getRetrofit().create(PoolApi.class);

    public PoolServiceImpl(BaseService baseService) {
        super(baseService);
    }

    @Override
    public Result<List<Pool>> getPoolList(Options options) throws ApiException {
        Call<List<Pool>> call = this.poolApi.getPoolList(this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<PoolInfo>> getPoolInformation(List<String> poolIds, Options options) throws ApiException {
        for (String poolId : poolIds) {
            this.validateBech32(poolId);
        }
        Call<List<PoolInfo>> call = this.poolApi.getPoolInformation(this.buildBody(poolIds), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<PoolStakeSnapshot>> getPoolStakeSnapshot(String poolBech32, Options options) throws ApiException {
        this.validateBech32(poolBech32);
        Call<List<PoolStakeSnapshot>> call = this.poolApi.getPoolStakeSnapshot(poolBech32, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<PoolDelegator>> getPoolDelegatorsList(String poolBech32, Options options) throws ApiException {
        this.validateBech32(poolBech32);
        Call<List<PoolDelegator>> call = this.poolApi.getPoolDelegatorsList(poolBech32, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<PoolDelegatorHistory>> getPoolDelegatorsHistory(String poolBech32, Integer epochNo, Options options) throws ApiException {
        if (epochNo != null) {
            this.validateEpoch(epochNo);
        }
        this.validateBech32(poolBech32);
        Call<List<PoolDelegatorHistory>> call = this.poolApi.getPoolDelegatorsHistory(poolBech32, epochNo, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<PoolBlock>> getPoolBlocksByEpoch(String poolBech32, Integer epochNo, Options options) throws ApiException {
        this.validateEpoch(epochNo);
        this.validateBech32(poolBech32);
        Call<List<PoolBlock>> call = this.poolApi.getPoolBlocksByEpoch(poolBech32, epochNo, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<PoolBlock>> getPoolBlocks(String poolBech32, Options options) throws ApiException {
        this.validateBech32(poolBech32);
        Call<List<PoolBlock>> call = this.poolApi.getPoolBlocks(poolBech32, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<PoolHistory> getPoolHistoryByEpoch(String poolBech32, Integer epochNo, Options options) throws ApiException {
        this.validateBech32(poolBech32);
        this.validateEpoch(epochNo);
        Call<List<PoolHistory>> call = this.poolApi.getPoolHistoryByEpoch(poolBech32, epochNo, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponseGetOne(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<PoolHistory>> getPoolHistory(String poolBech32, Options options) throws ApiException {
        this.validateBech32(poolBech32);
        Call<List<PoolHistory>> call = this.poolApi.getPoolHistory(poolBech32, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<PoolUpdate>> getPoolUpdatesByPoolBech32(String poolBech32, Options options) throws ApiException {
        this.validateBech32(poolBech32);
        Call<List<PoolUpdate>> call = this.poolApi.getPoolUpdatesByPoolBech32(poolBech32, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<PoolUpdate>> getPoolUpdates(Options options) throws ApiException {
        Call<List<PoolUpdate>> call = this.poolApi.getPoolUpdates(this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<PoolRelay>> getPoolRelays(Options options) throws ApiException {
        Call<List<PoolRelay>> call = this.poolApi.getPoolRelays(this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<PoolMetadata>> getPoolMetadata(Options options) throws ApiException {
        return this.getPoolMetadata(Collections.emptyList(), options);
    }

    @Override
    public Result<List<PoolMetadata>> getPoolMetadata(List<String> poolIds, Options options) throws ApiException {
        for (String poolId : poolIds) {
            this.validateBech32(poolId);
        }
        Call<List<PoolMetadata>> call = this.poolApi.getPoolMetadata(this.buildBody(poolIds), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    private Map<String, Object> buildBody(List<String> poolIds) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        if (!poolIds.isEmpty()) {
            bodyMap.put("_pool_bech32_ids", poolIds);
        }
        return bodyMap;
    }
}

