/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.script.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rest.koios.client.backend.api.base.BaseService;
import rest.koios.client.backend.api.base.Result;
import rest.koios.client.backend.api.base.exception.ApiException;
import rest.koios.client.backend.api.script.ScriptService;
import rest.koios.client.backend.api.script.api.ScriptApi;
import rest.koios.client.backend.api.script.model.DatumInfo;
import rest.koios.client.backend.api.script.model.NativeScript;
import rest.koios.client.backend.api.script.model.PlutusScript;
import rest.koios.client.backend.api.script.model.ScriptRedeemer;
import rest.koios.client.backend.factory.options.Options;
import retrofit2.Call;
import retrofit2.Response;

public class ScriptServiceImpl
extends BaseService
implements ScriptService {
    private final ScriptApi scriptApi = (ScriptApi)this.getRetrofit().create(ScriptApi.class);

    public ScriptServiceImpl(BaseService baseService) {
        super(baseService);
    }

    @Override
    public Result<List<NativeScript>> getNativeScriptList(Options options) throws ApiException {
        Call<List<NativeScript>> call = this.scriptApi.getNativeScriptList(this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<PlutusScript>> getPlutusScriptList(Options options) throws ApiException {
        Call<List<PlutusScript>> call = this.scriptApi.getPlutusScriptList(this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<ScriptRedeemer>> getScriptRedeemers(String scriptHash, Options options) throws ApiException {
        this.validateHexFormat(scriptHash);
        Call<List<ScriptRedeemer>> call = this.scriptApi.getScriptRedeemers(scriptHash, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<DatumInfo>> getDatumInformation(List<String> datumHashes, Options options) throws ApiException {
        for (String datumHash : datumHashes) {
            this.validateHexFormat(datumHash);
        }
        Call<List<DatumInfo>> call = this.scriptApi.getDatumInformation(this.buildBody("_datum_hashes", datumHashes), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    private Map<String, Object> buildBody(String arrayObjString, List<String> list) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put(arrayObjString, list);
        return bodyMap;
    }
}

