/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.factory;

import rest.koios.client.backend.factory.ApiVersion;
import rest.koios.client.backend.factory.BackendService;
import rest.koios.client.backend.factory.OperationType;
import rest.koios.client.backend.factory.impl.BackendServiceImpl;

public class BackendFactory {
    private BackendFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static BackendService getKoiosMainnetService() {
        return BackendFactory.getKoiosMainnetService(ApiVersion.VERSION_0);
    }

    public static BackendService getKoiosMainnetService(ApiVersion apiVersion) {
        return new BackendServiceImpl(OperationType.KOIOS_MAINNET, apiVersion);
    }

    public static BackendService getKoiosGuildService() {
        return BackendFactory.getKoiosGuildService(ApiVersion.VERSION_0);
    }

    public static BackendService getKoiosGuildService(ApiVersion apiVersion) {
        return new BackendServiceImpl(OperationType.KOIOS_GUILD, apiVersion);
    }

    public static BackendService getKoiosPreviewService() {
        return BackendFactory.getKoiosPreviewService(ApiVersion.VERSION_0);
    }

    public static BackendService getKoiosPreviewService(ApiVersion apiVersion) {
        return new BackendServiceImpl(OperationType.KOIOS_PREVIEW, apiVersion);
    }

    public static BackendService getKoiosPreprodService() {
        return BackendFactory.getKoiosPreprodService(ApiVersion.VERSION_0);
    }

    public static BackendService getKoiosPreprodService(ApiVersion apiVersion) {
        return new BackendServiceImpl(OperationType.KOIOS_PREPROD, apiVersion);
    }

    public static BackendService getCustomRPCService(String baseUrl) {
        return new BackendServiceImpl(baseUrl);
    }
}

