/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.account.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rest.koios.client.backend.api.account.AccountService;
import rest.koios.client.backend.api.account.api.AccountApi;
import rest.koios.client.backend.api.account.model.AccountAddress;
import rest.koios.client.backend.api.account.model.AccountAssets;
import rest.koios.client.backend.api.account.model.AccountHistory;
import rest.koios.client.backend.api.account.model.AccountInfo;
import rest.koios.client.backend.api.account.model.AccountRewards;
import rest.koios.client.backend.api.account.model.AccountUTxO;
import rest.koios.client.backend.api.account.model.AccountUpdates;
import rest.koios.client.backend.api.account.model.StakeAddress;
import rest.koios.client.backend.api.base.BaseService;
import rest.koios.client.backend.api.base.Result;
import rest.koios.client.backend.api.base.exception.ApiException;
import rest.koios.client.backend.factory.options.Options;
import retrofit2.Call;
import retrofit2.Response;

public class AccountServiceImpl
extends BaseService
implements AccountService {
    private final AccountApi accountApi = (AccountApi)this.getRetrofit().create(AccountApi.class);

    public AccountServiceImpl(BaseService baseService) {
        super(baseService);
    }

    @Override
    public Result<List<StakeAddress>> getAccountList(Options options) throws ApiException {
        Call<List<StakeAddress>> call = this.accountApi.getAccountList(this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<AccountInfo>> getAccountInformation(List<String> stakeAddresses, Options options) throws ApiException {
        for (String address : stakeAddresses) {
            this.validateBech32(address);
        }
        Call<List<AccountInfo>> call = this.accountApi.getAccountInformation(this.buildBody("_stake_addresses", stakeAddresses, null, null, null), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<AccountUTxO>> getAccountUTxOs(String stakeAddress, Options options) throws ApiException {
        this.validateBech32(stakeAddress);
        Call<List<AccountUTxO>> call = this.accountApi.getAccountUTxOs(stakeAddress, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<AccountInfo>> getCachedAccountInformation(List<String> stakeAddresses, Options options) throws ApiException {
        for (String address : stakeAddresses) {
            this.validateBech32(address);
        }
        Call<List<AccountInfo>> call = this.accountApi.getCachedAccountInformation(this.buildBody("_stake_addresses", stakeAddresses, null, null, null), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<AccountRewards>> getAccountRewards(List<String> addressList, Integer epochNo, Options options) throws ApiException {
        for (String address : addressList) {
            this.validateBech32(address);
        }
        if (epochNo != null) {
            this.validateEpoch(epochNo);
        }
        Call<List<AccountRewards>> call = this.accountApi.getAccountRewards(this.buildBody("_stake_addresses", addressList, epochNo, null, null), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<AccountUpdates>> getAccountUpdates(List<String> addressList, Options options) throws ApiException {
        for (String address : addressList) {
            this.validateBech32(address);
        }
        Call<List<AccountUpdates>> call = this.accountApi.getAccountUpdates(this.buildBody("_stake_addresses", addressList, null, null, null), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<AccountAddress>> getAccountAddresses(List<String> addressList, boolean firstOnly, boolean empty, Options options) throws ApiException {
        for (String address : addressList) {
            this.validateBech32(address);
        }
        Call<List<AccountAddress>> call = this.accountApi.getAccountAddresses(this.buildBody("_stake_addresses", addressList, null, firstOnly, empty), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<AccountAssets>> getAccountAssets(List<String> addressList, Integer epochNo, Options options) throws ApiException {
        for (String address : addressList) {
            this.validateBech32(address);
        }
        if (epochNo != null) {
            this.validateEpoch(epochNo);
        }
        Call<List<AccountAssets>> call = this.accountApi.getAccountAssets(this.buildBody("_stake_addresses", addressList, epochNo, null, null), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<AccountHistory>> getAccountHistory(List<String> addressList, Integer epochNo, Options options) throws ApiException {
        for (String address : addressList) {
            this.validateBech32(address);
        }
        if (epochNo != null) {
            this.validateEpoch(epochNo);
        }
        Call<List<AccountHistory>> call = this.accountApi.getAccountHistory(this.buildBody("_stake_addresses", addressList, epochNo, null, null), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    private Map<String, Object> buildBody(String arrayObjString, List<String> list, Integer epochNo, Boolean firstOnly, Boolean empty) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put(arrayObjString, list);
        if (epochNo != null) {
            bodyMap.put("_epoch_no", epochNo);
        }
        if (firstOnly != null) {
            bodyMap.put("_first_only", firstOnly);
        }
        if (empty != null) {
            bodyMap.put("_empty", empty);
        }
        return bodyMap;
    }
}

