/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.block.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rest.koios.client.backend.api.base.BaseService;
import rest.koios.client.backend.api.base.Result;
import rest.koios.client.backend.api.base.exception.ApiException;
import rest.koios.client.backend.api.block.BlockService;
import rest.koios.client.backend.api.block.api.BlockApi;
import rest.koios.client.backend.api.block.model.Block;
import rest.koios.client.backend.api.block.model.BlockInfo;
import rest.koios.client.backend.api.block.model.BlockTxHash;
import rest.koios.client.backend.factory.options.Limit;
import rest.koios.client.backend.factory.options.Options;
import retrofit2.Call;
import retrofit2.Response;

public class BlockServiceImpl
extends BaseService
implements BlockService {
    private final BlockApi blockApi = (BlockApi)this.getRetrofit().create(BlockApi.class);

    public BlockServiceImpl(BaseService baseService) {
        super(baseService);
    }

    @Override
    public Result<Block> getLatestBlock() throws ApiException {
        Options options = Options.builder().option(Limit.of(1L)).build();
        Call<List<Block>> call = this.blockApi.getBlockList(this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponseGetOne(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<Block>> getBlockList(Options options) throws ApiException {
        Call<List<Block>> call = this.blockApi.getBlockList(this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<BlockInfo> getBlockInformation(String blockHash) throws ApiException {
        this.validateHexFormat(blockHash);
        Call<List<BlockInfo>> call = this.blockApi.getBlockInformation(this.buildBody(List.of(blockHash)), Collections.emptyMap());
        try {
            Response<Object> response = this.execute(call);
            return this.processResponseGetOne(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<BlockInfo>> getBlocksInformation(List<String> blockHashes, Options options) throws ApiException {
        for (String blockHash : blockHashes) {
            this.validateHexFormat(blockHash);
        }
        Call<List<BlockInfo>> call = this.blockApi.getBlockInformation(this.buildBody(blockHashes), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<BlockTxHash>> getBlockTransactions(List<String> blockHashes, Options options) throws ApiException {
        for (String blockHash : blockHashes) {
            this.validateHexFormat(blockHash);
        }
        Call<List<BlockTxHash>> call = this.blockApi.getBlockTransactions(this.buildBody(blockHashes), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    private Map<String, Object> buildBody(List<String> blockHashes) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("_block_hashes", blockHashes);
        return bodyMap;
    }
}

