/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.network.impl;

import java.io.IOException;
import java.util.List;
import rest.koios.client.backend.api.base.BaseService;
import rest.koios.client.backend.api.base.Result;
import rest.koios.client.backend.api.base.exception.ApiException;
import rest.koios.client.backend.api.network.NetworkService;
import rest.koios.client.backend.api.network.api.NetworkApi;
import rest.koios.client.backend.api.network.model.Genesis;
import rest.koios.client.backend.api.network.model.ParamUpdateProposal;
import rest.koios.client.backend.api.network.model.Tip;
import rest.koios.client.backend.api.network.model.Totals;
import rest.koios.client.backend.factory.options.Options;
import retrofit2.Call;
import retrofit2.Response;

public class NetworkServiceImpl
extends BaseService
implements NetworkService {
    private final NetworkApi networkApi = (NetworkApi)this.getRetrofit().create(NetworkApi.class);

    public NetworkServiceImpl(BaseService baseService) {
        super(baseService);
    }

    @Override
    public Result<Tip> getChainTip() throws ApiException {
        Call<List<Tip>> call = this.networkApi.getChainTip();
        try {
            Response<Object> response = this.execute(call);
            return this.processResponseGetOne(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<Genesis> getGenesisInfo() throws ApiException {
        Call<List<Genesis>> call = this.networkApi.getGenesisInfo();
        try {
            Response<Object> response = this.execute(call);
            return this.processResponseGetOne(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<Totals> getHistoricalTokenomicStatsByEpoch(Integer epochNo) throws ApiException {
        this.validateEpoch(epochNo);
        Call<List<Totals>> call = this.networkApi.getHistoricalTokenomicStatsByEpoch(epochNo);
        try {
            Response<Object> response = this.execute(call);
            return this.processResponseGetOne(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<Totals>> getHistoricalTokenomicStats(Options options) throws ApiException {
        Call<List<Totals>> call = this.networkApi.getHistoricalTokenomicStats(this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<ParamUpdateProposal>> getParamUpdateProposals(Options options) throws ApiException {
        Call<List<ParamUpdateProposal>> call = this.networkApi.getParamUpdateProposals(this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }
}

