/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.asset.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rest.koios.client.backend.api.asset.AssetService;
import rest.koios.client.backend.api.asset.api.AssetApi;
import rest.koios.client.backend.api.asset.model.Asset;
import rest.koios.client.backend.api.asset.model.AssetAddress;
import rest.koios.client.backend.api.asset.model.AssetHistory;
import rest.koios.client.backend.api.asset.model.AssetInformation;
import rest.koios.client.backend.api.asset.model.AssetSummary;
import rest.koios.client.backend.api.asset.model.AssetTokenRegistry;
import rest.koios.client.backend.api.asset.model.PaymentAddress;
import rest.koios.client.backend.api.asset.model.PolicyAsset;
import rest.koios.client.backend.api.asset.model.PolicyAssetInfo;
import rest.koios.client.backend.api.base.BaseService;
import rest.koios.client.backend.api.base.Result;
import rest.koios.client.backend.api.base.common.TxHash;
import rest.koios.client.backend.api.base.common.UTxO;
import rest.koios.client.backend.api.base.exception.ApiException;
import rest.koios.client.backend.factory.options.Options;
import rest.koios.client.utils.Tuple;
import retrofit2.Call;
import retrofit2.Response;

public class AssetServiceImpl
extends BaseService
implements AssetService {
    private final AssetApi assetApi = (AssetApi)this.getRetrofit().create(AssetApi.class);

    public AssetServiceImpl(String baseUrl, String apiToken) {
        super(baseUrl, apiToken);
    }

    @Override
    public Result<List<Asset>> getAssetList(Options options) throws ApiException {
        Call<List<Asset>> call = this.assetApi.getAssetList(this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<AssetTokenRegistry>> getAssetTokenRegistry(Options options) throws ApiException {
        Call<List<AssetTokenRegistry>> call = this.assetApi.getAssetTokenRegistry(this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<AssetAddress>> getAssetsAddresses(String assetPolicy, String assetName, Options options) throws ApiException {
        this.validateHexFormat(assetPolicy);
        this.validateHexFormat(assetName);
        Call<List<AssetAddress>> call = this.assetApi.getAssetsAddresses(assetPolicy, assetName, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<PaymentAddress>> getNFTAddress(String assetPolicy, String assetName, Options options) throws ApiException {
        this.validateHexFormat(assetPolicy);
        this.validateHexFormat(assetName);
        Call<List<PaymentAddress>> call = this.assetApi.getNFTAddress(assetPolicy, assetName, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<AssetInformation> getAssetInformation(String assetPolicy, String assetName) throws ApiException {
        this.validateHexFormat(assetPolicy);
        this.validateHexFormat(assetName);
        Call<List<AssetInformation>> call = this.assetApi.getAssetInformation(assetPolicy, assetName);
        try {
            Response<Object> response = this.execute(call);
            return this.processResponseGetOne(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<AssetInformation> getAssetInformationBulk(List<Tuple<String, String>> assetList, Options options) throws ApiException {
        if (assetList == null) {
            return this.badRequestResult("The server cannot process the request due to invalid input");
        }
        for (Tuple<String, String> tuple : assetList) {
            this.validateHexFormat((String)tuple._1);
            this.validateHexFormat((String)tuple._2);
        }
        Call<List<AssetInformation>> call = this.assetApi.getAssetInformationBulk(this.buildBody("_asset_list", assetList), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponseGetOne(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<UTxO>> getAssetUTxOs(List<Tuple<String, String>> assetList, Boolean extended, Options options) throws ApiException {
        if (assetList == null) {
            return this.badRequestResult("The server cannot process the request due to invalid input");
        }
        for (Tuple<String, String> tuple : assetList) {
            this.validateHexFormat((String)tuple._1);
            this.validateHexFormat((String)tuple._2);
        }
        Call<List<UTxO>> call = this.assetApi.getAssetUTxOs(this.buildBodyUTxOs(assetList, extended), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<AssetHistory>> getAssetHistory(String assetPolicy, String assetName, Options options) throws ApiException {
        this.validateHexFormat(assetPolicy);
        this.validateHexFormat(assetName);
        Call<List<AssetHistory>> call = this.assetApi.getAssetHistory(assetPolicy, assetName, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<PolicyAssetInfo>> getPolicyAssetInformation(String assetPolicy, Options options) throws ApiException {
        this.validateHexFormat(assetPolicy);
        Call<List<PolicyAssetInfo>> call = this.assetApi.getPolicyAssetInformation(assetPolicy, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<PolicyAsset>> getPolicyAssetList(String assetPolicy, Options options) throws ApiException {
        this.validateHexFormat(assetPolicy);
        Call<List<PolicyAsset>> call = this.assetApi.getPolicyAssetList(assetPolicy, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<AssetSummary> getAssetSummary(String assetPolicy, String assetName) throws ApiException {
        this.validateHexFormat(assetPolicy);
        this.validateHexFormat(assetName);
        Call<List<AssetSummary>> call = this.assetApi.getAssetSummary(assetPolicy, assetName);
        try {
            Response<Object> response = this.execute(call);
            return this.processResponseGetOne(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<TxHash>> getAssetTransactions(String assetPolicy, String assetName, Options options) throws ApiException {
        return this.getAssetTransactions(assetPolicy, assetName, 0, false, options);
    }

    @Override
    public Result<List<TxHash>> getAssetTransactions(String assetPolicy, String assetName, Integer afterBlockHeight, boolean history, Options options) throws ApiException {
        this.validateHexFormat(assetPolicy);
        this.validateHexFormat(assetName);
        Call<List<TxHash>> call = this.assetApi.getAssetTransactionHistory(assetPolicy, assetName, afterBlockHeight, history, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    private Map<String, Object> buildBody(String arrayObjString, List<Tuple<String, String>> list) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        ArrayList lists = new ArrayList();
        list.forEach(tuple -> {
            ArrayList<String> tupleList = new ArrayList<String>();
            tupleList.add((String)tuple._1);
            tupleList.add((String)tuple._2);
            lists.add(tupleList);
        });
        bodyMap.put(arrayObjString, lists);
        return bodyMap;
    }

    private Map<String, Object> buildBodyUTxOs(List<Tuple<String, String>> list, boolean extended) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        ArrayList lists = new ArrayList();
        list.forEach(tuple -> {
            ArrayList<String> tupleList = new ArrayList<String>();
            tupleList.add((String)tuple._1);
            tupleList.add((String)tuple._2);
            lists.add(tupleList);
        });
        bodyMap.put("_asset_list", lists);
        bodyMap.put("_extended", extended);
        return bodyMap;
    }
}

