/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.epoch.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import rest.koios.client.backend.api.base.BaseService;
import rest.koios.client.backend.api.base.Result;
import rest.koios.client.backend.api.base.exception.ApiException;
import rest.koios.client.backend.api.epoch.EpochService;
import rest.koios.client.backend.api.epoch.api.EpochApi;
import rest.koios.client.backend.api.epoch.model.EpochBlockProtocols;
import rest.koios.client.backend.api.epoch.model.EpochInfo;
import rest.koios.client.backend.api.epoch.model.EpochParams;
import rest.koios.client.backend.factory.options.Limit;
import rest.koios.client.backend.factory.options.Options;
import retrofit2.Call;
import retrofit2.Response;

public class EpochServiceImpl
extends BaseService
implements EpochService {
    private final EpochApi epochApi = (EpochApi)this.getRetrofit().create(EpochApi.class);

    public EpochServiceImpl(String baseUrl, String apiToken) {
        super(baseUrl, apiToken);
    }

    @Override
    public Result<EpochInfo> getLatestEpochInfo() throws ApiException {
        Options options = Options.builder().option(Limit.of(1L)).build();
        Call<List<EpochInfo>> call = this.epochApi.getEpochInformation(null, false, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponseGetOne(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<EpochInfo> getEpochInformationByEpoch(Integer epochNo) throws ApiException {
        this.validateEpoch(epochNo);
        Call<List<EpochInfo>> call = this.epochApi.getEpochInformation(epochNo, false, Collections.emptyMap());
        try {
            Response<Object> response = this.execute(call);
            return this.processResponseGetOne(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<EpochInfo>> getEpochInformation(boolean includeNextEpoch, Options options) throws ApiException {
        Call<List<EpochInfo>> call = this.epochApi.getEpochInformation(null, includeNextEpoch, this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<EpochParams> getLatestEpochParameters() throws ApiException {
        Options options = Options.builder().option(Limit.of(1L)).build();
        Call<List<EpochParams>> call = this.epochApi.getEpochParameters(this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponseGetOne(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<EpochParams> getEpochParametersByEpoch(Integer epochNo) throws ApiException {
        this.validateEpoch(epochNo);
        Call<List<EpochParams>> call = this.epochApi.getEpochParametersByEpoch(epochNo);
        try {
            Response<Object> response = this.execute(call);
            return this.processResponseGetOne(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<EpochParams>> getEpochParameters(Options options) throws ApiException {
        Call<List<EpochParams>> call = this.epochApi.getEpochParameters(this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<EpochBlockProtocols> getEpochBlockProtocolsByEpoch(Integer epochNo) throws ApiException {
        this.validateEpoch(epochNo);
        Call<List<EpochBlockProtocols>> call = this.epochApi.getEpochBlockProtocolsByEpoch(epochNo);
        try {
            Response<Object> response = this.execute(call);
            return this.processResponseGetOne(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<EpochBlockProtocols>> getEpochBlockProtocols(Options options) throws ApiException {
        Call<List<EpochBlockProtocols>> call = this.epochApi.getEpochBlockProtocols(this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }
}

