/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.transactions.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import rest.koios.client.backend.api.base.BaseService;
import rest.koios.client.backend.api.base.Result;
import rest.koios.client.backend.api.base.common.UTxO;
import rest.koios.client.backend.api.base.exception.ApiException;
import rest.koios.client.backend.api.transactions.TransactionsService;
import rest.koios.client.backend.api.transactions.api.TransactionApi;
import rest.koios.client.backend.api.transactions.model.TxInfo;
import rest.koios.client.backend.api.transactions.model.TxMetadata;
import rest.koios.client.backend.api.transactions.model.TxMetadataLabels;
import rest.koios.client.backend.api.transactions.model.TxStatus;
import rest.koios.client.backend.factory.options.Options;
import retrofit2.Call;
import retrofit2.Response;

public class TransactionsServiceImpl
extends BaseService
implements TransactionsService {
    private final TransactionApi transactionApi = (TransactionApi)this.getRetrofit().create(TransactionApi.class);

    public TransactionsServiceImpl(String baseUrl, String apiToken) {
        super(baseUrl, apiToken);
    }

    @Override
    public Result<List<UTxO>> getUTxOInfo(List<String> utxoRefs, boolean extended) throws ApiException {
        Call<List<UTxO>> call = this.transactionApi.getUTxOInfo(this.buildBodyUTxOs(utxoRefs, extended), Collections.emptyMap());
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<TxInfo> getTransactionInformation(String txHash) throws ApiException {
        this.validateHexFormat(txHash);
        Call<List<TxInfo>> call = this.transactionApi.getTransactionInformation(this.buildBody(List.of(txHash)), Collections.emptyMap());
        try {
            Response<Object> response = this.execute(call);
            return this.processResponseGetOne(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<TxInfo>> getTransactionInformation(List<String> txHashes, Options options) throws ApiException {
        for (String tx : txHashes) {
            this.validateHexFormat(tx);
        }
        Call<List<TxInfo>> call = this.transactionApi.getTransactionInformation(this.buildBody(txHashes), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<TxMetadata>> getTransactionMetadata(List<String> txHashes, Options options) throws ApiException {
        for (String tx : txHashes) {
            this.validateHexFormat(tx);
        }
        Call<List<TxMetadata>> call = this.transactionApi.getTransactionMetadata(this.buildBody(txHashes), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<TxMetadataLabels>> getTransactionMetadataLabels(Options options) throws ApiException {
        Call<List<TxMetadataLabels>> call = this.transactionApi.getTransactionMetadataLabels(this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<String> submitTx(byte[] cborData) throws ApiException {
        RequestBody requestBody = RequestBody.create((byte[])cborData, (MediaType)MediaType.parse((String)"application/cbor"));
        Call<String> txnCall = this.transactionApi.submitTx(requestBody);
        try {
            Response response = txnCall.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<TxStatus>> getTransactionStatus(List<String> txHashes, Options options) throws ApiException {
        for (String tx : txHashes) {
            this.validateHexFormat(tx);
        }
        Call<List<TxStatus>> call = this.transactionApi.getTransactionStatus(this.buildBody(txHashes), this.optionsToParamMap(options));
        try {
            Response<Object> response = this.execute(call);
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    private Map<String, Object> buildBody(List<String> txHashes) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("_tx_hashes", txHashes);
        return bodyMap;
    }

    private Map<String, Object> buildBodyUTxOs(List<String> utxoRefs, boolean extended) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("_utxo_refs", utxoRefs);
        bodyMap.put("_extended", extended);
        return bodyMap;
    }
}

