/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.factory;

import rest.koios.client.backend.factory.ApiVersion;
import rest.koios.client.backend.factory.BackendService;
import rest.koios.client.backend.factory.OperationType;
import rest.koios.client.backend.factory.impl.BackendServiceImpl;

public class BackendFactory {
    private BackendFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static BackendService getKoiosMainnetService() {
        return BackendFactory.getKoiosMainnetService(null);
    }

    public static BackendService getKoiosMainnetService(String apiToken) {
        return BackendFactory.getKoiosMainnetService(ApiVersion.VERSION_1, apiToken);
    }

    public static BackendService getKoiosMainnetService(ApiVersion apiVersion, String apiToken) {
        return new BackendServiceImpl(OperationType.KOIOS_MAINNET, apiVersion, apiToken);
    }

    public static BackendService getKoiosGuildService() {
        return BackendFactory.getKoiosGuildService(ApiVersion.VERSION_1, null);
    }

    public static BackendService getKoiosGuildService(String apiToken) {
        return BackendFactory.getKoiosGuildService(ApiVersion.VERSION_1, apiToken);
    }

    public static BackendService getKoiosGuildService(ApiVersion apiVersion, String apiToken) {
        return new BackendServiceImpl(OperationType.KOIOS_GUILD, apiVersion, apiToken);
    }

    public static BackendService getKoiosPreviewService() {
        return BackendFactory.getKoiosPreviewService(null);
    }

    public static BackendService getKoiosPreviewService(String apiToken) {
        return BackendFactory.getKoiosPreviewService(ApiVersion.VERSION_1, apiToken);
    }

    public static BackendService getKoiosPreviewService(ApiVersion apiVersion, String apiToken) {
        return new BackendServiceImpl(OperationType.KOIOS_PREVIEW, apiVersion, apiToken);
    }

    public static BackendService getKoiosPreprodService() {
        return BackendFactory.getKoiosPreprodService(null);
    }

    public static BackendService getKoiosPreprodService(String apiToken) {
        return BackendFactory.getKoiosPreprodService(ApiVersion.VERSION_1, apiToken);
    }

    public static BackendService getKoiosPreprodService(ApiVersion apiVersion, String apiToken) {
        return new BackendServiceImpl(OperationType.KOIOS_PREPROD, apiVersion, apiToken);
    }

    public static BackendService getCustomRPCService(String baseUrl) {
        return BackendFactory.getCustomRPCService(baseUrl, null);
    }

    public static BackendService getCustomRPCService(String baseUrl, String apiToken) {
        return new BackendServiceImpl(baseUrl, apiToken);
    }
}

