/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.factory.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rest.koios.client.backend.api.account.AccountService;
import rest.koios.client.backend.api.account.impl.AccountServiceImpl;
import rest.koios.client.backend.api.address.AddressService;
import rest.koios.client.backend.api.address.impl.AddressServiceImpl;
import rest.koios.client.backend.api.asset.AssetService;
import rest.koios.client.backend.api.asset.impl.AssetServiceImpl;
import rest.koios.client.backend.api.block.BlockService;
import rest.koios.client.backend.api.block.impl.BlockServiceImpl;
import rest.koios.client.backend.api.epoch.EpochService;
import rest.koios.client.backend.api.epoch.impl.EpochServiceImpl;
import rest.koios.client.backend.api.network.NetworkService;
import rest.koios.client.backend.api.network.impl.NetworkServiceImpl;
import rest.koios.client.backend.api.pool.PoolService;
import rest.koios.client.backend.api.pool.impl.PoolServiceImpl;
import rest.koios.client.backend.api.script.ScriptService;
import rest.koios.client.backend.api.script.impl.ScriptServiceImpl;
import rest.koios.client.backend.api.transactions.TransactionsService;
import rest.koios.client.backend.api.transactions.impl.TransactionsServiceImpl;
import rest.koios.client.backend.factory.ApiVersion;
import rest.koios.client.backend.factory.BackendService;
import rest.koios.client.backend.factory.OperationType;

public class BackendServiceImpl
implements BackendService {
    private static final Logger log = LoggerFactory.getLogger(BackendServiceImpl.class);
    private final NetworkService networkService;
    private final EpochService epochService;
    private final BlockService blockService;
    private final TransactionsService transactionsService;
    private final AccountService accountService;
    private final AddressService addressService;
    private final AssetService assetService;
    private final PoolService poolService;
    private final ScriptService scriptService;

    public BackendServiceImpl(String baseUrl) {
        this(baseUrl, null);
    }

    public BackendServiceImpl(String baseUrl, String apiToken) {
        log.info("Koios URL: " + baseUrl);
        this.networkService = new NetworkServiceImpl(baseUrl, apiToken);
        this.epochService = new EpochServiceImpl(baseUrl, apiToken);
        this.blockService = new BlockServiceImpl(baseUrl, apiToken);
        this.transactionsService = new TransactionsServiceImpl(baseUrl, apiToken);
        this.accountService = new AccountServiceImpl(baseUrl, apiToken);
        this.addressService = new AddressServiceImpl(baseUrl, apiToken);
        this.assetService = new AssetServiceImpl(baseUrl, apiToken);
        this.poolService = new PoolServiceImpl(baseUrl, apiToken);
        this.scriptService = new ScriptServiceImpl(baseUrl, apiToken);
    }

    public BackendServiceImpl(OperationType operationType, ApiVersion apiVersion, String apiToken) {
        this(operationType.getBaseUrl() + apiVersion.getVersion() + "/", apiToken);
    }

    @Override
    public NetworkService getNetworkService() {
        return this.networkService;
    }

    @Override
    public EpochService getEpochService() {
        return this.epochService;
    }

    @Override
    public BlockService getBlockService() {
        return this.blockService;
    }

    @Override
    public TransactionsService getTransactionsService() {
        return this.transactionsService;
    }

    @Override
    public AccountService getAccountService() {
        return this.accountService;
    }

    @Override
    public AddressService getAddressService() {
        return this.addressService;
    }

    @Override
    public AssetService getAssetService() {
        return this.assetService;
    }

    @Override
    public PoolService getPoolService() {
        return this.poolService;
    }

    @Override
    public ScriptService getScriptService() {
        return this.scriptService;
    }
}

