/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.factory.options;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import rest.koios.client.backend.factory.options.Option;
import rest.koios.client.backend.factory.options.OptionType;
import rest.koios.client.backend.factory.options.filters.LogicalOperatorFilter;
import rest.koios.client.backend.factory.options.filters.LogicalOperatorFilterType;

public class Options {
    private final List<Option> optionList;
    public static final Options EMPTY = null;

    public Options() {
        this.optionList = new ArrayList<Option>();
    }

    public Options(List<Option> optionList) {
        this.optionList = optionList;
    }

    public Map<String, String> toMap() {
        ArrayList<Option> optionArrayList = new ArrayList<Option>();
        ArrayList<Option> filters = new ArrayList<Option>();
        for (Option option : this.optionList) {
            if (option.getOptionType() == OptionType.FILTER) {
                filters.add(option);
                continue;
            }
            optionArrayList.add(option);
        }
        if (filters.size() >= 2) {
            optionArrayList.add(LogicalOperatorFilter.of(LogicalOperatorFilterType.AND, filters.toArray(new Option[0])));
        } else if (filters.size() == 1) {
            optionArrayList.add((Option)filters.get(0));
        }
        return optionArrayList.stream().collect(Collectors.toMap(Option::getOptionTypeValue, Option::getValue));
    }

    public static OptionsBuilder builder() {
        return new OptionsBuilder();
    }

    public List<Option> getOptionList() {
        return this.optionList;
    }

    public static class OptionsBuilder {
        private List<Option> options;

        public OptionsBuilder option(Option option) {
            if (this.options == null) {
                this.options = new ArrayList<Option>();
            }
            this.options.add(option);
            return this;
        }

        public OptionsBuilder options(Collection<? extends Option> options) {
            if (this.options == null) {
                this.options = new ArrayList<Option>();
            }
            this.options.addAll(options);
            return this;
        }

        public Options build() {
            return new Options(this.options);
        }
    }
}

