/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.factory.options.filters;

import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import rest.koios.client.backend.factory.options.Option;
import rest.koios.client.backend.factory.options.OptionType;
import rest.koios.client.backend.factory.options.filters.LogicalOperatorFilterType;

public class LogicalOperatorFilter
extends Option {
    private final List<Option> options;
    private final LogicalOperatorFilterType logicalOperatorFilterType;

    public LogicalOperatorFilter(LogicalOperatorFilterType logicalOperatorFilterType, List<Option> options) {
        super(OptionType.LOGICAL_FILTER);
        this.logicalOperatorFilterType = logicalOperatorFilterType;
        this.options = options;
    }

    public static LogicalOperatorFilter of(LogicalOperatorFilterType logicalOperatorFilterType, Option ... options) {
        if (options == null || options.length == 0) {
            throw new IllegalStateException("At least one Option Object is required");
        }
        return new LogicalOperatorFilter(logicalOperatorFilterType, Arrays.stream(options).collect(Collectors.toList()));
    }

    @Override
    public String getOptionTypeValue() {
        return this.getLogicalOperatorFilterType().name().toLowerCase();
    }

    @Override
    public String getValue() {
        StringJoiner stringJoiner = new StringJoiner(",");
        this.getOptions().forEach(option -> stringJoiner.add(option.getOptionTypeValue() + "." + option.getValue()));
        return "(" + String.valueOf(stringJoiner) + ")";
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public LogicalOperatorFilterType getLogicalOperatorFilterType() {
        return this.logicalOperatorFilterType;
    }
}

