/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.factory.options.filters;

import rest.koios.client.backend.factory.options.Option;
import rest.koios.client.backend.factory.options.OptionType;

public class NotOperatorFilter
extends Option {
    private final Option option;

    public NotOperatorFilter(Option option) {
        super(OptionType.NOT_OPERATOR);
        this.option = option;
    }

    public static NotOperatorFilter of(Option option) {
        if (option == null) {
            throw new IllegalStateException("Cannot Negate null Option");
        }
        return new NotOperatorFilter(option);
    }

    @Override
    public String getOptionTypeValue() {
        if (this.option.getOptionType() == OptionType.LOGICAL_FILTER) {
            return "not." + this.getOption().getOptionTypeValue();
        }
        return this.getOption().getOptionTypeValue();
    }

    @Override
    public String getValue() {
        if (this.option.getOptionType() == OptionType.LOGICAL_FILTER) {
            return this.getOption().getValue();
        }
        return "not." + this.getOption().getValue();
    }

    public Option getOption() {
        return this.option;
    }
}

