/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.address.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import rest.koios.client.backend.api.address.AddressService;
import rest.koios.client.backend.api.address.api.AddressApi;
import rest.koios.client.backend.api.address.model.AddressAsset;
import rest.koios.client.backend.api.address.model.AddressInfo;
import rest.koios.client.backend.api.address.model.AddressUtxo;
import rest.koios.client.backend.api.base.BaseService;
import rest.koios.client.backend.api.base.Result;
import rest.koios.client.backend.api.base.common.TxHash;
import rest.koios.client.backend.api.base.common.UTxO;
import rest.koios.client.backend.api.base.exception.ApiException;
import rest.koios.client.backend.factory.options.Options;
import rest.koios.client.backend.factory.options.SortType;
import retrofit2.Call;

public class AddressServiceImpl
extends BaseService
implements AddressService {
    private final AddressApi addressApi = (AddressApi)this.getRetrofit().create(AddressApi.class);

    public AddressServiceImpl(String baseUrl, String apiToken) {
        super(baseUrl, apiToken);
    }

    @Override
    public Result<AddressInfo> getAddressInformation(String address) throws ApiException {
        this.validateBech32(address);
        Call<List<AddressInfo>> call = this.addressApi.getAddressInformation(this.buildBody("_addresses", List.of(address), null), this.optionsToParamMap(Options.EMPTY));
        Result<AddressInfo> result = this.processResponseGetOne(call);
        if (result.isSuccessful()) {
            result.getValue().setUtxoSet(new TreeSet<AddressUtxo>(result.getValue().getUtxoSet()));
        }
        return result;
    }

    @Override
    public Result<List<AddressInfo>> getAddressInformation(List<String> addressList, SortType utxoSortType, Options options) throws ApiException {
        for (String address : addressList) {
            this.validateBech32(address);
        }
        Call<List<AddressInfo>> call = this.addressApi.getAddressInformation(this.buildBody("_addresses", addressList, null), this.optionsToParamMap(options));
        Result<List<AddressInfo>> result = this.processResponse(call);
        if (result.isSuccessful()) {
            ((List)result.getValue()).forEach(addressInfo -> {
                if (utxoSortType == SortType.DESC) {
                    addressInfo.setUtxoSet(new TreeSet<AddressUtxo>(addressInfo.getUtxoSet()).descendingSet());
                } else {
                    addressInfo.setUtxoSet(new TreeSet<AddressUtxo>(addressInfo.getUtxoSet()));
                }
            });
        }
        return result;
    }

    @Override
    public Result<List<UTxO>> getAddressUTxOs(List<String> addresses, boolean extended, Options options) throws ApiException {
        for (String address : addresses) {
            this.validateBech32(address);
        }
        Call<List<UTxO>> call = this.addressApi.getAddressUTxOs(this.buildBodyUTxOs(addresses, extended), this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<UTxO>> getUTxOsFromPaymentCredentials(List<String> paymentCredentials, boolean extended, Options options) throws ApiException {
        for (String address : paymentCredentials) {
            this.validateHexFormat(address);
        }
        Call<List<UTxO>> call = this.addressApi.getUTxOsFromPaymentCredentials(this.buildBodyUTxOsFromPaymentCredentials(paymentCredentials, extended), this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<TxHash>> getAddressTransactions(List<String> addressList, Options options) throws ApiException {
        return this.getAddressTransactions(addressList, 0, options);
    }

    @Override
    public Result<List<TxHash>> getAddressTransactions(List<String> addressList, Integer afterBlockHeight, Options options) throws ApiException {
        if (afterBlockHeight < 0) {
            throw new ApiException("Non Positive \"afterBlockHeight\" Value");
        }
        for (String address : addressList) {
            this.validateBech32(address);
        }
        Call<List<TxHash>> call = this.addressApi.getAddressTransactions(this.buildBody("_addresses", addressList, afterBlockHeight), this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<AddressAsset>> getAddressAssets(List<String> addressList, Options options) throws ApiException {
        for (String address : addressList) {
            this.validateBech32(address);
        }
        Call<List<AddressAsset>> call = this.addressApi.getAddressAssets(this.buildBody("_addresses", addressList, null), this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<TxHash>> getTransactionsByPaymentCredentials(List<String> paymentCredentialsList, Options options) throws ApiException {
        return this.getTransactionsByPaymentCredentials(paymentCredentialsList, 0, options);
    }

    @Override
    public Result<List<TxHash>> getTransactionsByPaymentCredentials(List<String> paymentCredentialsList, Integer afterBlockHeight, Options options) throws ApiException {
        if (afterBlockHeight < 0) {
            throw new ApiException("Non Positive \"afterBlockHeight\" Value");
        }
        for (String paymentCredentials : paymentCredentialsList) {
            this.validateHexFormat(paymentCredentials);
        }
        Call<List<TxHash>> call = this.addressApi.getTransactionsByPaymentCredentials(this.buildBody("_payment_credentials", paymentCredentialsList, afterBlockHeight), this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    private Map<String, Object> buildBody(String arrayObjString, List<String> list, Integer afterBlockHeight) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put(arrayObjString, list);
        if (afterBlockHeight != null) {
            bodyMap.put("_after_block_height", afterBlockHeight);
        }
        return bodyMap;
    }

    private Map<String, Object> buildBodyUTxOs(List<String> addresses, boolean extended) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("_addresses", addresses);
        bodyMap.put("_extended", extended);
        return bodyMap;
    }

    private Map<String, Object> buildBodyUTxOsFromPaymentCredentials(List<String> paymentCredentials, boolean extended) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("_payment_credentials", paymentCredentials);
        bodyMap.put("_extended", extended);
        return bodyMap;
    }
}

