/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.base;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rest.koios.client.backend.api.base.Result;
import rest.koios.client.backend.api.base.exception.ApiException;
import rest.koios.client.backend.api.base.interceptor.GzipInterceptor;
import rest.koios.client.backend.factory.options.Options;
import rest.koios.client.utils.Bech32Util;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class BaseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseService.class);
    private final Retrofit retrofit;
    private int retriesCount = 5;
    private boolean retryOnTimeout = true;
    private final String apiToken;
    private int readTimeoutSec = 300;
    private int connectTimeoutSec = 300;
    private int sleepTimeSec = 60;
    private boolean gzipCompression = true;

    public BaseService(String baseUrl) {
        this(baseUrl, null);
    }

    public BaseService(String baseUrl, final String apiToken) {
        String sleepTimeSecEnv;
        String retryOnTimeoutEnv;
        String strRetries;
        int connectTimeoutSec;
        String strConnectTimeoutSec;
        int readTimeoutSec;
        this.apiToken = apiToken;
        String strReadTimeoutSec = System.getenv("KOIOS_JAVA_LIB_READ_TIMEOUT_SEC");
        if (strReadTimeoutSec != null && !strReadTimeoutSec.isEmpty() && (readTimeoutSec = Integer.parseInt(strReadTimeoutSec)) >= 1) {
            this.readTimeoutSec = readTimeoutSec;
        }
        if ((strConnectTimeoutSec = System.getenv("KOIOS_JAVA_LIB_CONNECT_TIMEOUT_SEC")) != null && !strConnectTimeoutSec.isEmpty() && (connectTimeoutSec = Integer.parseInt(strConnectTimeoutSec)) >= 1) {
            this.connectTimeoutSec = connectTimeoutSec;
        }
        boolean logging = Boolean.parseBoolean(System.getenv("KOIOS_JAVA_LIB_LOGGING"));
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        okHttpClientBuilder.readTimeout((long)this.readTimeoutSec, TimeUnit.SECONDS).connectTimeout((long)this.connectTimeoutSec, TimeUnit.SECONDS);
        if (logging) {
            HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
            interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            okHttpClientBuilder.addInterceptor((Interceptor)interceptor).build();
        }
        if (apiToken != null && !apiToken.isEmpty()) {
            okHttpClientBuilder.addInterceptor(new Interceptor(){

                @NotNull
                public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
                    Request original = chain.request();
                    Request request = original.newBuilder().header("Authorization", "Bearer " + apiToken).method(original.method(), original.body()).build();
                    return chain.proceed(request);
                }
            });
        }
        if (System.getenv("KOIOS_JAVA_LIB_GZIP_COMPRESSION") != null) {
            this.gzipCompression = Boolean.parseBoolean(System.getenv("KOIOS_JAVA_LIB_GZIP_COMPRESSION"));
        }
        if (this.gzipCompression) {
            okHttpClientBuilder.addInterceptor((Interceptor)new GzipInterceptor());
        }
        if ((strRetries = System.getenv("KOIOS_JAVA_LIB_RETRIES_COUNT")) != null && !strRetries.isEmpty()) {
            this.retriesCount = Math.max(Integer.parseInt(strRetries), 1);
        }
        if ((retryOnTimeoutEnv = System.getenv("KOIOS_JAVA_LIB_RETRY_ON_TIMEOUT")) != null && !Boolean.parseBoolean(retryOnTimeoutEnv)) {
            this.retryOnTimeout = false;
        }
        if ((sleepTimeSecEnv = System.getenv("KOIOS_JAVA_LIB_RETRY_SLEEP_TIME_SEC")) != null && !sleepTimeSecEnv.isEmpty()) {
            this.sleepTimeSec = Math.max(Integer.parseInt(sleepTimeSecEnv), 60);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.retrofit = new Retrofit.Builder().baseUrl(baseUrl).client(okHttpClientBuilder.build()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper)).build();
    }

    protected <T> Result<T> processResponseGetOne(Call<List<T>> call) throws ApiException {
        try {
            retrofit2.Response<?> response = this.execute(call);
            if (response.isSuccessful()) {
                if (response.body() != null && !((List)response.body()).isEmpty()) {
                    return Result.builder().successful(true).response(response.toString()).value(((List)response.body()).get(0)).code(response.code()).build();
                }
                if (response.body() != null) {
                    return Result.builder().successful(false).response("Response Body is Empty").code(404).build();
                }
                return Result.builder().successful(false).response("Response Body is Invalid").code(500).build();
            }
            return Result.builder().successful(false).response(Objects.requireNonNull(response.errorBody()).string()).code(response.code()).build();
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    protected <T> Result<T> badRequestResult(String responseText) {
        return Result.builder().successful(false).response(responseText).code(400).build();
    }

    protected <T> Result<T> processResponse(Call<?> call) throws ApiException {
        try {
            retrofit2.Response<?> response = this.execute(call);
            if (response.isSuccessful()) {
                return Result.builder().successful(true).response(response.toString()).value(response.body()).code(response.code()).build();
            }
            return Result.builder().successful(false).response(Objects.requireNonNull(response.errorBody()).string()).code(response.code()).build();
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    public retrofit2.Response<?> execute(Call<?> call) throws ApiException, IOException {
        int tryCount = 1;
        retrofit2.Response response = null;
        while (tryCount < this.retriesCount) {
            try {
                response = call.clone().execute();
                if (response.code() == 429) {
                    log.warn("429 Too Many Requests.");
                    tryCount = this.retry(tryCount, response.code());
                    continue;
                }
                if (response.code() == 504) {
                    log.warn(response.message());
                    tryCount = this.retry(tryCount, response.code());
                    continue;
                }
                return response;
            }
            catch (SocketTimeoutException e) {
                log.warn(e.getMessage());
                if (this.retryOnTimeout) {
                    tryCount = this.retry(tryCount, null);
                    continue;
                }
                throw new ApiException("Timeout Error");
            }
        }
        if (response != null) {
            throw new ApiException("Retry Count Exceeded (" + tryCount + "/" + this.retriesCount + "). Reason: " + String.valueOf(response));
        }
        throw new ApiException("Retry Count Exceeded (" + tryCount + "/" + this.retriesCount + ").");
    }

    private void sleep(int timeMillis) {
        try {
            Thread.sleep(timeMillis);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private int retry(int tryCount, Integer responseCode) throws ApiException {
        if (++tryCount < this.retriesCount) {
            log.info("Retrying in {}s ... (" + tryCount + "/" + this.retriesCount + ")", (Object)(this.getSleepTimeSec() * tryCount));
            this.sleep(this.getSleepTimeSec() * tryCount);
        } else {
            if (responseCode == null) {
                throw new ApiException("Timeout Error");
            }
            if (responseCode == 429) {
                throw new ApiException("429 Too Many Requests.");
            }
        }
        return tryCount;
    }

    protected void validateEpoch(Integer epochNo) throws ApiException {
        if (epochNo == null) {
            throw new ApiException("Null Value for \"epochNo\"");
        }
        if (epochNo < 0) {
            throw new ApiException("Non Positive \"epochNo\" Value");
        }
    }

    protected void validateBech32(String bech32) throws ApiException {
        if (!Bech32Util.isValid(bech32)) {
            throw new ApiException("Invalid Bech32 Format");
        }
    }

    protected void validateHexFormat(String hex) throws ApiException {
        if (!hex.isEmpty() && !hex.matches("^[\\da-fA-F]+$")) {
            throw new ApiException("Invalid Hexadecimal String Format");
        }
    }

    protected Map<String, String> optionsToParamMap(Options options) {
        Map<String, String> paramsMap = Collections.emptyMap();
        if (options != null && !options.getOptionList().isEmpty()) {
            paramsMap = options.toMap();
        }
        return paramsMap;
    }

    @Generated
    public Retrofit getRetrofit() {
        return this.retrofit;
    }

    @Generated
    public int getRetriesCount() {
        return this.retriesCount;
    }

    @Generated
    public boolean isRetryOnTimeout() {
        return this.retryOnTimeout;
    }

    @Generated
    public String getApiToken() {
        return this.apiToken;
    }

    @Generated
    public int getReadTimeoutSec() {
        return this.readTimeoutSec;
    }

    @Generated
    public int getConnectTimeoutSec() {
        return this.connectTimeoutSec;
    }

    @Generated
    public int getSleepTimeSec() {
        return this.sleepTimeSec;
    }

    @Generated
    public boolean isGzipCompression() {
        return this.gzipCompression;
    }
}

