/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.base.interceptor;

import java.io.IOException;
import java.util.Objects;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

public class GzipInterceptor
implements Interceptor {
    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request.Builder newRequest = chain.request().newBuilder();
        newRequest.addHeader("Accept-Encoding", "deflate, gzip");
        Response response = chain.proceed(newRequest.build());
        if (this.isGzipped(response).booleanValue()) {
            return this.unzip(response);
        }
        return response;
    }

    private Response unzip(Response response) throws IOException {
        if (response.body() == null) {
            return response;
        }
        GzipSource gzipSource = new GzipSource((Source)response.body().source());
        String bodyString = Okio.buffer((Source)gzipSource).readUtf8();
        ResponseBody responseBody = ResponseBody.create((String)bodyString, (MediaType)response.body().contentType());
        Headers strippedHeaders = response.headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build();
        return response.newBuilder().headers(strippedHeaders).body(responseBody).message(response.message()).build();
    }

    private Boolean isGzipped(Response response) {
        return response.header("Content-Encoding") != null && Objects.equals(response.header("Content-Encoding"), "gzip");
    }
}

