/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.block.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import rest.koios.client.backend.api.base.BaseService;
import rest.koios.client.backend.api.base.Result;
import rest.koios.client.backend.api.base.exception.ApiException;
import rest.koios.client.backend.api.block.BlockService;
import rest.koios.client.backend.api.block.api.BlockApi;
import rest.koios.client.backend.api.block.model.Block;
import rest.koios.client.backend.api.block.model.BlockInfo;
import rest.koios.client.backend.api.block.model.BlockTxHash;
import rest.koios.client.backend.api.transactions.model.TxInfo;
import rest.koios.client.backend.factory.options.Limit;
import rest.koios.client.backend.factory.options.Options;
import retrofit2.Call;

public class BlockServiceImpl
extends BaseService
implements BlockService {
    private final BlockApi blockApi = (BlockApi)this.getRetrofit().create(BlockApi.class);

    public BlockServiceImpl(String baseUrl, String apiToken) {
        super(baseUrl, apiToken);
    }

    @Override
    public Result<Block> getLatestBlock() throws ApiException {
        Options options = Options.builder().option(Limit.of(1L)).build();
        Call<List<Block>> call = this.blockApi.getBlockList(this.optionsToParamMap(options));
        return this.processResponseGetOne(call);
    }

    @Override
    public Result<List<Block>> getBlockList(Options options) throws ApiException {
        Call<List<Block>> call = this.blockApi.getBlockList(this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<BlockInfo> getBlockInformation(String blockHash) throws ApiException {
        this.validateHexFormat(blockHash);
        Call<List<BlockInfo>> call = this.blockApi.getBlockInformation(this.buildBody(List.of(blockHash)), Collections.emptyMap());
        return this.processResponseGetOne(call);
    }

    @Override
    public Result<List<BlockInfo>> getBlocksInformation(List<String> blockHashes, Options options) throws ApiException {
        for (String blockHash : blockHashes) {
            this.validateHexFormat(blockHash);
        }
        Call<List<BlockInfo>> call = this.blockApi.getBlockInformation(this.buildBody(blockHashes), this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<BlockTxHash>> getBlockTransactions(List<String> blockHashes, Options options) throws ApiException {
        for (String blockHash : blockHashes) {
            this.validateHexFormat(blockHash);
        }
        Call<List<BlockTxHash>> call = this.blockApi.getBlockTransactions(this.buildBody(blockHashes), this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<TxInfo>> getBlockTransactionsInfo(List<String> blockHashes, Boolean inputs, Boolean metadata, Boolean assets, Boolean withdrawals, Boolean certs, Boolean scripts, Options options) throws ApiException {
        for (String blockHash : blockHashes) {
            this.validateHexFormat(blockHash);
        }
        Call<List<TxInfo>> call = this.blockApi.getBlockTransactionsInfo(this.buildBodyBlockTxInfo(blockHashes, inputs, metadata, assets, withdrawals, certs, scripts), this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    private Map<String, Object> buildBodyBlockTxInfo(List<String> blockHashes, Boolean inputs, Boolean metadata, Boolean assets, Boolean withdrawals, Boolean certs, Boolean scripts) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("_block_hashes", blockHashes);
        bodyMap.put("_inputs", Optional.ofNullable(inputs).orElse(false));
        bodyMap.put("_metadata", Optional.ofNullable(metadata).orElse(false));
        bodyMap.put("_assets", Optional.ofNullable(assets).orElse(false));
        bodyMap.put("_withdrawals", Optional.ofNullable(withdrawals).orElse(false));
        bodyMap.put("_certs", Optional.ofNullable(certs).orElse(false));
        bodyMap.put("_scripts", Optional.ofNullable(scripts).orElse(false));
        return bodyMap;
    }

    private Map<String, Object> buildBody(List<String> blockHashes) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("_block_hashes", blockHashes);
        return bodyMap;
    }
}

