/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.network.impl;

import java.util.List;
import rest.koios.client.backend.api.base.BaseService;
import rest.koios.client.backend.api.base.Result;
import rest.koios.client.backend.api.base.exception.ApiException;
import rest.koios.client.backend.api.network.NetworkService;
import rest.koios.client.backend.api.network.api.NetworkApi;
import rest.koios.client.backend.api.network.model.Genesis;
import rest.koios.client.backend.api.network.model.ParamUpdateProposal;
import rest.koios.client.backend.api.network.model.Tip;
import rest.koios.client.backend.api.network.model.Totals;
import rest.koios.client.backend.api.network.model.Withdrawal;
import rest.koios.client.backend.factory.options.Options;
import retrofit2.Call;

public class NetworkServiceImpl
extends BaseService
implements NetworkService {
    private final NetworkApi networkApi = (NetworkApi)this.getRetrofit().create(NetworkApi.class);

    public NetworkServiceImpl(String baseUrl, String apiToken) {
        super(baseUrl, apiToken);
    }

    @Override
    public Result<Tip> getChainTip() throws ApiException {
        Call<List<Tip>> call = this.networkApi.getChainTip();
        return this.processResponseGetOne(call);
    }

    @Override
    public Result<Genesis> getGenesisInfo() throws ApiException {
        Call<List<Genesis>> call = this.networkApi.getGenesisInfo();
        return this.processResponseGetOne(call);
    }

    @Override
    public Result<Totals> getHistoricalTokenomicStatsByEpoch(Integer epochNo) throws ApiException {
        this.validateEpoch(epochNo);
        Call<List<Totals>> call = this.networkApi.getHistoricalTokenomicStatsByEpoch(epochNo);
        return this.processResponseGetOne(call);
    }

    @Override
    public Result<List<Totals>> getHistoricalTokenomicStats(Options options) throws ApiException {
        Call<List<Totals>> call = this.networkApi.getHistoricalTokenomicStats(this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<ParamUpdateProposal>> getParamUpdateProposals(Options options) throws ApiException {
        Call<List<ParamUpdateProposal>> call = this.networkApi.getParamUpdateProposals(this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<Withdrawal>> getReserveWithdrawals(Options options) throws ApiException {
        Call<List<Withdrawal>> call = this.networkApi.getReserveWithdrawals(this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<Withdrawal>> getTreasuryWithdrawals(Options options) throws ApiException {
        Call<List<Withdrawal>> call = this.networkApi.getTreasuryWithdrawals(this.optionsToParamMap(options));
        return this.processResponse(call);
    }
}

