/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.governance.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rest.koios.client.backend.api.base.BaseService;
import rest.koios.client.backend.api.base.Result;
import rest.koios.client.backend.api.base.exception.ApiException;
import rest.koios.client.backend.api.governance.GovernanceService;
import rest.koios.client.backend.api.governance.api.GovernanceApi;
import rest.koios.client.backend.api.governance.model.CommitteeInfo;
import rest.koios.client.backend.api.governance.model.CommitteeVote;
import rest.koios.client.backend.api.governance.model.DRep;
import rest.koios.client.backend.api.governance.model.DRepDelegator;
import rest.koios.client.backend.api.governance.model.DRepEpochSummary;
import rest.koios.client.backend.api.governance.model.DRepInfo;
import rest.koios.client.backend.api.governance.model.DRepMetadata;
import rest.koios.client.backend.api.governance.model.DRepUpdate;
import rest.koios.client.backend.api.governance.model.DRepVote;
import rest.koios.client.backend.api.governance.model.PoolVote;
import rest.koios.client.backend.api.governance.model.Proposal;
import rest.koios.client.backend.api.governance.model.ProposalVote;
import rest.koios.client.backend.api.governance.model.ProposalVotingSummary;
import rest.koios.client.backend.factory.options.Options;
import retrofit2.Call;

public class GovernanceServiceImpl
extends BaseService
implements GovernanceService {
    private final GovernanceApi governanceApi = (GovernanceApi)this.getRetrofit().create(GovernanceApi.class);

    public GovernanceServiceImpl(String baseUrl, String apiToken) {
        super(baseUrl, apiToken);
    }

    @Override
    public Result<List<DRepEpochSummary>> getDRepsEpochSummary(Integer epochNo, Options options) throws ApiException {
        Call<List<DRepEpochSummary>> call = this.governanceApi.getDRepsEpochSummary(epochNo, this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<DRep>> getDRepsList(Options options) throws ApiException {
        Call<List<DRep>> call = this.governanceApi.getDRepsList(this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<DRepInfo>> getDRepsInfo(List<String> drepIds, Options options) throws ApiException {
        Call<List<DRepInfo>> call = this.governanceApi.getDRepsInfo(this.buildBody(drepIds), this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<DRepMetadata>> getDRepsMetadata(List<String> drepIds, Options options) throws ApiException {
        Call<List<DRepMetadata>> call = this.governanceApi.getDRepsMetadata(this.buildBody(drepIds), this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<DRepUpdate>> getDRepsUpdates(String drepId, Options options) throws ApiException {
        Call<List<DRepUpdate>> call = this.governanceApi.getDRepsUpdates(drepId, this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<DRepVote>> getDRepsVotes(String drepId, Options options) throws ApiException {
        Call<List<DRepVote>> call = this.governanceApi.getDRepsVotes(drepId, this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<DRepDelegator>> getDRepsDelegators(String drepId, Options options) throws ApiException {
        Call<List<DRepDelegator>> call = this.governanceApi.getDRepsDelegators(drepId, this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<CommitteeInfo>> getCommitteeInformation(Options options) throws ApiException {
        Call<List<CommitteeInfo>> call = this.governanceApi.getCommitteeInformation(this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<CommitteeVote>> getCommitteeVotes(String ccHotId, Options options) throws ApiException {
        Call<List<CommitteeVote>> call = this.governanceApi.getCommitteeVotes(ccHotId, this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<Proposal>> getProposalList(Options options) throws ApiException {
        Call<List<Proposal>> call = this.governanceApi.getProposalList(this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<Proposal>> getVoterProposals(String voterId, Options options) throws ApiException {
        Call<List<Proposal>> call = this.governanceApi.getVoterProposal(voterId, this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<ProposalVotingSummary>> getProposalVotingSummary(String proposalId, Options options) throws ApiException {
        Call<List<ProposalVotingSummary>> call = this.governanceApi.getProposalVotingSummary(proposalId, this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<ProposalVote>> getProposalVotes(String proposalId, Options options) throws ApiException {
        Call<List<ProposalVote>> call = this.governanceApi.getProposalVotes(proposalId, this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<PoolVote>> getPoolVotes(String poolBech32, Options options) throws ApiException {
        Call<List<PoolVote>> call = this.governanceApi.getPoolVotes(poolBech32, this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    private Map<String, Object> buildBody(List<String> txHashes) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("_drep_ids", txHashes);
        return bodyMap;
    }
}

