/*
 * Decompiled with CFR 0.152.
 */
package rest.koios.client.backend.api.transactions.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import rest.koios.client.backend.api.base.BaseService;
import rest.koios.client.backend.api.base.Result;
import rest.koios.client.backend.api.base.common.UTxO;
import rest.koios.client.backend.api.base.exception.ApiException;
import rest.koios.client.backend.api.transactions.TransactionsService;
import rest.koios.client.backend.api.transactions.api.TransactionApi;
import rest.koios.client.backend.api.transactions.model.RawTx;
import rest.koios.client.backend.api.transactions.model.TxInfo;
import rest.koios.client.backend.api.transactions.model.TxMetadata;
import rest.koios.client.backend.api.transactions.model.TxMetadataLabels;
import rest.koios.client.backend.api.transactions.model.TxStatus;
import rest.koios.client.backend.factory.options.Options;
import retrofit2.Call;

public class TransactionsServiceImpl
extends BaseService
implements TransactionsService {
    private final TransactionApi transactionApi = (TransactionApi)this.getRetrofit().create(TransactionApi.class);

    public TransactionsServiceImpl(String baseUrl, String apiToken) {
        super(baseUrl, apiToken);
    }

    @Override
    public Result<List<UTxO>> getUTxOInfo(List<String> utxoRefs, boolean extended) throws ApiException {
        Call<List<UTxO>> call = this.transactionApi.getUTxOInfo(this.buildBodyUTxOs(utxoRefs, extended), Collections.emptyMap());
        return this.processResponse(call);
    }

    @Override
    public Result<List<RawTx>> getRawTransaction(List<String> txHashes, Options options) throws ApiException {
        for (String tx : txHashes) {
            this.validateHexFormat(tx);
        }
        Call<List<RawTx>> call = this.transactionApi.getRawTransaction(this.buildBody(txHashes), this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<TxInfo> getTransactionInformation(String txHash) throws ApiException {
        this.validateHexFormat(txHash);
        Call<List<TxInfo>> call = this.transactionApi.getTransactionInformation(this.buildTxInfoBody(List.of(txHash)), Collections.emptyMap());
        return this.processResponseGetOne(call);
    }

    @Override
    public Result<List<TxInfo>> getTransactionInformation(List<String> txHashes, Options options) throws ApiException {
        for (String tx : txHashes) {
            this.validateHexFormat(tx);
        }
        Call<List<TxInfo>> call = this.transactionApi.getTransactionInformation(this.buildTxInfoBody(txHashes), this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<TxMetadata>> getTransactionMetadata(List<String> txHashes, Options options) throws ApiException {
        for (String tx : txHashes) {
            this.validateHexFormat(tx);
        }
        Call<List<TxMetadata>> call = this.transactionApi.getTransactionMetadata(this.buildBody(txHashes), this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<List<TxMetadataLabels>> getTransactionMetadataLabels(Options options) throws ApiException {
        Call<List<TxMetadataLabels>> call = this.transactionApi.getTransactionMetadataLabels(this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    @Override
    public Result<String> submitTx(byte[] cborData) throws ApiException {
        RequestBody requestBody = RequestBody.create((byte[])cborData, (MediaType)MediaType.parse((String)"application/cbor"));
        Call<String> txnCall = this.transactionApi.submitTx(requestBody);
        return this.processResponse(txnCall);
    }

    @Override
    public Result<List<TxStatus>> getTransactionStatus(List<String> txHashes, Options options) throws ApiException {
        for (String tx : txHashes) {
            this.validateHexFormat(tx);
        }
        Call<List<TxStatus>> call = this.transactionApi.getTransactionStatus(this.buildBody(txHashes), this.optionsToParamMap(options));
        return this.processResponse(call);
    }

    private Map<String, Object> buildTxInfoBody(List<String> txHashes) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("_tx_hashes", txHashes);
        bodyMap.put("_inputs", true);
        bodyMap.put("_metadata", true);
        bodyMap.put("_assets", true);
        bodyMap.put("_withdrawals", true);
        bodyMap.put("_certs", true);
        bodyMap.put("_scripts", true);
        bodyMap.put("_bytecode", true);
        return bodyMap;
    }

    private Map<String, Object> buildBody(List<String> txHashes) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("_tx_hashes", txHashes);
        return bodyMap;
    }

    private Map<String, Object> buildBodyUTxOs(List<String> utxoRefs, boolean extended) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("_utxo_refs", utxoRefs);
        bodyMap.put("_extended", extended);
        return bodyMap;
    }
}

