/*
 * Decompiled with CFR 0.152.
 */
package tv.danmaku.ijk.media.player.misc;

import android.annotation.TargetApi;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import tv.danmaku.ijk.media.player.IjkMediaMeta;
import tv.danmaku.ijk.media.player.misc.IMediaFormat;

public class IjkMediaFormat
implements IMediaFormat {
    public static final String KEY_IJK_CODEC_LONG_NAME_UI = "ijk-codec-long-name-ui";
    public static final String KEY_IJK_CODEC_NAME_UI = "ijk-codec-name-ui";
    public static final String KEY_IJK_BIT_RATE_UI = "ijk-bit-rate-ui";
    public static final String KEY_IJK_CODEC_PROFILE_LEVEL_UI = "ijk-profile-level-ui";
    public static final String KEY_IJK_CODEC_PIXEL_FORMAT_UI = "ijk-pixel-format-ui";
    public static final String KEY_IJK_RESOLUTION_UI = "ijk-resolution-ui";
    public static final String KEY_IJK_FRAME_RATE_UI = "ijk-frame-rate-ui";
    public static final String KEY_IJK_SAMPLE_RATE_UI = "ijk-sample-rate-ui";
    public static final String KEY_IJK_CHANNEL_UI = "ijk-channel-ui";
    public static final String CODEC_NAME_H264 = "h264";
    public final IjkMediaMeta.IjkStreamMeta mMediaFormat;
    private static final Map<String, Formatter> sFormatterMap = new HashMap<String, Formatter>();

    public IjkMediaFormat(IjkMediaMeta.IjkStreamMeta streamMeta) {
        sFormatterMap.put(KEY_IJK_CODEC_LONG_NAME_UI, new Formatter(){

            @Override
            public String doFormat(IjkMediaFormat mediaFormat) {
                return IjkMediaFormat.this.mMediaFormat.getString("codec_long_name");
            }
        });
        sFormatterMap.put(KEY_IJK_CODEC_NAME_UI, new Formatter(){

            @Override
            public String doFormat(IjkMediaFormat mediaFormat) {
                return IjkMediaFormat.this.mMediaFormat.getString("codec_name");
            }
        });
        sFormatterMap.put(KEY_IJK_BIT_RATE_UI, new Formatter(){

            @Override
            protected String doFormat(IjkMediaFormat mediaFormat) {
                int bitRate = mediaFormat.getInteger("bitrate");
                if (bitRate <= 0) {
                    return null;
                }
                if (bitRate < 1000) {
                    return String.format(Locale.US, "%d bit/s", bitRate);
                }
                return String.format(Locale.US, "%d kb/s", bitRate / 1000);
            }
        });
        sFormatterMap.put(KEY_IJK_CODEC_PROFILE_LEVEL_UI, new Formatter(){

            @Override
            protected String doFormat(IjkMediaFormat mediaFormat) {
                String profile;
                int profileIndex = mediaFormat.getInteger("codec_profile_id");
                switch (profileIndex) {
                    case 66: {
                        profile = "Baseline";
                        break;
                    }
                    case 578: {
                        profile = "Constrained Baseline";
                        break;
                    }
                    case 77: {
                        profile = "Main";
                        break;
                    }
                    case 88: {
                        profile = "Extended";
                        break;
                    }
                    case 100: {
                        profile = "High";
                        break;
                    }
                    case 110: {
                        profile = "High 10";
                        break;
                    }
                    case 2158: {
                        profile = "High 10 Intra";
                        break;
                    }
                    case 122: {
                        profile = "High 4:2:2";
                        break;
                    }
                    case 2170: {
                        profile = "High 4:2:2 Intra";
                        break;
                    }
                    case 144: {
                        profile = "High 4:4:4";
                        break;
                    }
                    case 244: {
                        profile = "High 4:4:4 Predictive";
                        break;
                    }
                    case 2292: {
                        profile = "High 4:4:4 Intra";
                        break;
                    }
                    case 44: {
                        profile = "CAVLC 4:4:4";
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                StringBuilder sb = new StringBuilder();
                sb.append(profile);
                String codecName = mediaFormat.getString("codec_name");
                if (!TextUtils.isEmpty((CharSequence)codecName) && codecName.equalsIgnoreCase(IjkMediaFormat.CODEC_NAME_H264)) {
                    int level = mediaFormat.getInteger("codec_level");
                    if (level < 10) {
                        return sb.toString();
                    }
                    sb.append(" Profile Level ");
                    sb.append(level / 10 % 10);
                    if (level % 10 != 0) {
                        sb.append(".");
                        sb.append(level % 10);
                    }
                }
                return sb.toString();
            }
        });
        sFormatterMap.put(KEY_IJK_CODEC_PIXEL_FORMAT_UI, new Formatter(){

            @Override
            protected String doFormat(IjkMediaFormat mediaFormat) {
                return mediaFormat.getString("codec_pixel_format");
            }
        });
        sFormatterMap.put(KEY_IJK_RESOLUTION_UI, new Formatter(){

            @Override
            protected String doFormat(IjkMediaFormat mediaFormat) {
                int width = mediaFormat.getInteger("width");
                int height = mediaFormat.getInteger("height");
                int sarNum = mediaFormat.getInteger("sar_num");
                int sarDen = mediaFormat.getInteger("sar_den");
                if (width <= 0 || height <= 0) {
                    return null;
                }
                if (sarNum <= 0 || sarDen <= 0) {
                    return String.format(Locale.US, "%d x %d", width, height);
                }
                return String.format(Locale.US, "%d x %d [SAR %d:%d]", width, height, sarNum, sarDen);
            }
        });
        sFormatterMap.put(KEY_IJK_FRAME_RATE_UI, new Formatter(){

            @Override
            protected String doFormat(IjkMediaFormat mediaFormat) {
                int fpsNum = mediaFormat.getInteger("fps_num");
                int fpsDen = mediaFormat.getInteger("fps_den");
                if (fpsNum <= 0 || fpsDen <= 0) {
                    return null;
                }
                return String.valueOf((float)fpsNum / (float)fpsDen);
            }
        });
        sFormatterMap.put(KEY_IJK_SAMPLE_RATE_UI, new Formatter(){

            @Override
            protected String doFormat(IjkMediaFormat mediaFormat) {
                int sampleRate = mediaFormat.getInteger("sample_rate");
                if (sampleRate <= 0) {
                    return null;
                }
                return String.format(Locale.US, "%d Hz", sampleRate);
            }
        });
        sFormatterMap.put(KEY_IJK_CHANNEL_UI, new Formatter(){

            @Override
            protected String doFormat(IjkMediaFormat mediaFormat) {
                int channelLayout = mediaFormat.getInteger("channel_layout");
                if (channelLayout <= 0) {
                    return null;
                }
                if ((long)channelLayout == 4L) {
                    return "mono";
                }
                if ((long)channelLayout == 3L) {
                    return "stereo";
                }
                return String.format(Locale.US, "%x", channelLayout);
            }
        });
        this.mMediaFormat = streamMeta;
    }

    @Override
    @TargetApi(value=16)
    public int getInteger(String name) {
        if (this.mMediaFormat == null) {
            return 0;
        }
        return this.mMediaFormat.getInt(name);
    }

    @Override
    public String getString(String name) {
        if (this.mMediaFormat == null) {
            return null;
        }
        if (sFormatterMap.containsKey(name)) {
            Formatter formatter = sFormatterMap.get(name);
            return formatter.format(this);
        }
        return this.mMediaFormat.getString(name);
    }

    private static abstract class Formatter {
        private Formatter() {
        }

        public String format(IjkMediaFormat mediaFormat) {
            String value = this.doFormat(mediaFormat);
            if (TextUtils.isEmpty((CharSequence)value)) {
                return this.getDefaultString();
            }
            return value;
        }

        protected abstract String doFormat(IjkMediaFormat var1);

        protected String getDefaultString() {
            return "N/A";
        }
    }
}

