/*
 * Decompiled with CFR 0.152.
 */
package io.github.carlosthe19916.webservices.providers;

import io.github.carlosthe19916.webservices.providers.ErrorBillServiceProviderFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.xml.ws.soap.SOAPFaultException;

public class ErrorBillServiceRegistry {
    private static volatile ErrorBillServiceRegistry instance;
    private List<ErrorBillServiceProviderFactory> factories = new LinkedList<ErrorBillServiceProviderFactory>();

    private ErrorBillServiceRegistry() {
        for (ErrorBillServiceProviderFactory factory : ServiceLoader.load(ErrorBillServiceProviderFactory.class)) {
            this.factories.add(factory);
        }
        this.factories.sort((t1, t2) -> t2.getPriority() - t1.getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ErrorBillServiceRegistry getInstance() {
        if (instance != null) return instance;
        Class<ErrorBillServiceRegistry> clazz = ErrorBillServiceRegistry.class;
        synchronized (ErrorBillServiceRegistry.class) {
            if (instance != null) return instance;
            instance = new ErrorBillServiceRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Set<ErrorBillServiceProviderFactory> getFactories(SOAPFaultException e) {
        TreeSet result = new TreeSet((t1, t2) -> t2.getPriority() - t1.getPriority());
        return this.factories.stream().filter(f -> f.isSupported(e)).collect(Collectors.toCollection(() -> result));
    }

    public Set<ErrorBillServiceProviderFactory> getFactories(int errorCode) {
        TreeSet result = new TreeSet((t1, t2) -> t2.getPriority() - t1.getPriority());
        return this.factories.stream().filter(f -> f.isSupported(errorCode)).collect(Collectors.toCollection(() -> result));
    }
}

