/*
 * Decompiled with CFR 0.152.
 */
package io.github.carlosthe19916.webservices.providers.errors;

import io.github.carlosthe19916.webservices.models.GetStatusResponseType;
import io.github.carlosthe19916.webservices.providers.AbstractErrorBillServiceProvider;
import io.github.carlosthe19916.webservices.providers.BillServiceModel;
import io.github.carlosthe19916.webservices.providers.errors.Constants;
import io.github.carlosthe19916.webservices.utils.Utils;
import io.github.carlosthe19916.webservices.wrappers.BillConsultServiceWrapper;
import io.github.carlosthe19916.webservices.wrappers.ServiceConfig;
import java.io.IOException;
import java.util.regex.Matcher;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.SAXException;
import service.sunat.gob.pe.billconsultservice.StatusResponse;

public class Error1033BillServiceProvider
extends AbstractErrorBillServiceProvider {
    private final Integer exceptionCode;
    private final BillServiceModel previousResult;

    public Error1033BillServiceProvider(Integer exceptionCode) {
        this.previousResult = null;
        this.exceptionCode = exceptionCode;
    }

    public Error1033BillServiceProvider(Integer exceptionCode, BillServiceModel previousResult) {
        this.exceptionCode = exceptionCode;
        this.previousResult = previousResult;
    }

    @Override
    public BillServiceModel sendBill(String fileName, byte[] file, ServiceConfig config) {
        String fileNameWithoutExtension = Utils.getFileNameWithoutExtension(fileName);
        Matcher matcher = Constants.FILENAME_STRUCTURE.matcher(fileNameWithoutExtension);
        if (matcher.matches()) {
            String[] split = fileNameWithoutExtension.split("-");
            String ruc = split[0];
            String tipo = split[1];
            String serie = split[2];
            int numero = Integer.parseInt(split[3]);
            ServiceConfig consultConfig = new ServiceConfig.Builder().url("https://e-factura.sunat.gob.pe/ol-it-wsconscpegem/billConsultService").username(config.getUsername()).password(config.getPassword()).build();
            StatusResponse statusResponse = BillConsultServiceWrapper.getStatus(consultConfig, ruc, tipo, serie, numero);
            StatusResponse statusCdrResponse = BillConsultServiceWrapper.getStatusCdr(consultConfig, ruc, tipo, serie, numero);
            BillServiceModel result = new BillServiceModel();
            result.setCode(Integer.parseInt(statusResponse.getStatusCode()));
            result.setDescription(statusResponse.getStatusMessage());
            GetStatusResponseType.searchByCode(statusResponse.getStatusCode()).ifPresent(consultResponseType -> {
                switch (consultResponseType) {
                    case EXISTE_Y_ACEPTADO: {
                        result.setStatus(BillServiceModel.Status.ACEPTADO);
                        break;
                    }
                    case EXISTE_PERO_RECHAZADO: {
                        result.setStatus(BillServiceModel.Status.RECHAZADO);
                        break;
                    }
                    case EXISTE_PERO_DADO_DE_BAJA: {
                        result.setStatus(BillServiceModel.Status.BAJA);
                    }
                }
            });
            if (statusCdrResponse.getContent() != null) {
                try {
                    result.setCdr(statusCdrResponse.getContent());
                    BillServiceModel cdrStatusModel = Utils.toModel(statusCdrResponse.getContent());
                    result.setCode(cdrStatusModel.getCode());
                    result.setDescription(cdrStatusModel.getDescription());
                    if (result.getStatus() == null) {
                        result.setStatus(cdrStatusModel.getStatus());
                    }
                }
                catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (result.getStatus() == null && result.getCdr() == null) {
                result.setStatus(BillServiceModel.Status.RECHAZADO);
            }
            return result;
        }
        return null;
    }
}

