/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.RedBlackTree;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;

public final class RedBlackTree$ {
    public static final RedBlackTree$ MODULE$ = new RedBlackTree$();

    public boolean isEmpty(RedBlackTree.Tree<?, ?> tree) {
        return tree == null;
    }

    public <A> boolean contains(RedBlackTree.Tree<A, ?> tree, A x, Ordering<A> evidence$1) {
        return this.lookup(tree, x, evidence$1) != null;
    }

    public <A, B> Option<B> get(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> evidence$2) {
        RedBlackTree.Tree<A, B> tree2 = this.lookup(tree, x, evidence$2);
        Option option = tree2 == null ? None$.MODULE$ : new Some<B>(tree2.value());
        return option;
    }

    public <A, B> RedBlackTree.Tree<A, B> lookup(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        while (true) {
            if (tree == null) {
                return null;
            }
            int cmp = ordering.compare(x, tree.key());
            if (cmp < 0) {
                tree = tree.left();
                continue;
            }
            if (cmp <= 0) break;
            tree = tree.right();
        }
        return tree;
    }

    public int count(RedBlackTree.Tree<?, ?> tree) {
        if (tree == null) {
            return 0;
        }
        return tree.count();
    }

    public <A, B, B1> RedBlackTree.Tree<A, B1> update(RedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> evidence$3) {
        return this.blacken(this.upd(tree, k, v, overwrite, evidence$3));
    }

    public <A, B> RedBlackTree.Tree<A, B> delete(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> evidence$4) {
        return this.blacken(this.del(tree, k, evidence$4));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <A, B> RedBlackTree.Tree<A, B> rangeImpl(RedBlackTree.Tree<A, B> tree, Option<A> from, Option<A> until, Ordering<A> evidence$5) {
        Tuple2<Option<A>, Option<A>> tuple2 = new Tuple2<Option<A>, Option<A>>(from, until);
        if (from instanceof Some) {
            Object from2 = ((Some)from).value();
            if (until instanceof Some) {
                Object until2 = ((Some)until).value();
                return this.range(tree, from2, until2, evidence$5);
            }
        }
        if (from instanceof Some) {
            Object from3 = ((Some)from).value();
            if (None$.MODULE$.equals(until)) {
                return this.from(tree, from3, evidence$5);
            }
        }
        if (tuple2 != null && None$.MODULE$.equals(from) && until instanceof Some) {
            Object until3 = ((Some)until).value();
            return this.until(tree, until3, evidence$5);
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        if (!None$.MODULE$.equals(from)) throw new MatchError(tuple2);
        if (!None$.MODULE$.equals(until)) throw new MatchError(tuple2);
        return tree;
    }

    public <A, B> RedBlackTree.Tree<A, B> range(RedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> evidence$6) {
        return this.blacken(this.doRange(tree, from, until, evidence$6));
    }

    public <A, B> RedBlackTree.Tree<A, B> from(RedBlackTree.Tree<A, B> tree, A from, Ordering<A> evidence$7) {
        return this.blacken(this.doFrom(tree, from, evidence$7));
    }

    public <A, B> RedBlackTree.Tree<A, B> to(RedBlackTree.Tree<A, B> tree, A to, Ordering<A> evidence$8) {
        return this.blacken(this.doTo(tree, to, evidence$8));
    }

    public <A, B> RedBlackTree.Tree<A, B> until(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> evidence$9) {
        return this.blacken(this.doUntil(tree, key, evidence$9));
    }

    public <A, B> RedBlackTree.Tree<A, B> drop(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$10) {
        return this.blacken(this.doDrop(tree, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> take(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$11) {
        return this.blacken(this.doTake(tree, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> slice(RedBlackTree.Tree<A, B> tree, int from, int until, Ordering<A> evidence$12) {
        return this.blacken(this.doSlice(tree, from, until));
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> smallest(RedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        RedBlackTree.Tree<A, B> result2 = tree;
        while (result2.left() != null) {
            result2 = result2.left();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> greatest(RedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        RedBlackTree.Tree<A, B> result2 = tree;
        while (result2.right() != null) {
            result2 = result2.right();
        }
        return var2_2;
    }

    public <A, B> RedBlackTree.Tree<A, B> tail(RedBlackTree.Tree<A, B> tree) {
        return this.blacken(this._tail$1(tree));
    }

    public <A, B> RedBlackTree.Tree<A, B> init(RedBlackTree.Tree<A, B> tree) {
        return this.blacken(this._init$1(tree));
    }

    public <A, B> RedBlackTree.Tree<A, B> minAfter(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        while (tree != null) {
            int cmp = ordering.compare(x, tree.key());
            if (cmp == 0) {
                return tree;
            }
            if (cmp < 0) {
                RedBlackTree.Tree<A, B> l = this.minAfter(tree.left(), x, ordering);
                if (l != null) {
                    return l;
                }
                return tree;
            }
            tree = tree.right();
        }
        return null;
    }

    public <A, B> RedBlackTree.Tree<A, B> maxBefore(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        while (true) {
            if (tree == null) {
                return null;
            }
            if (ordering.compare(x, tree.key()) > 0) break;
            tree = tree.left();
        }
        RedBlackTree.Tree<A, B> r = this.maxBefore(tree.right(), x, ordering);
        if (r != null) {
            return r;
        }
        return tree;
    }

    public <A, B, U> void foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        if (tree != null) {
            RedBlackTree.Tree<A, B> _foreach_tree = tree;
            while (true) {
                if (_foreach_tree.left() != null) {
                    this._foreach(_foreach_tree.left(), f);
                }
                f.apply(new Tuple2<A, B>(_foreach_tree.key(), _foreach_tree.value()));
                if (_foreach_tree.right() == null) break;
                _foreach_tree = _foreach_tree.right();
            }
        }
    }

    public <A, X, Y> boolean keysEqual(RedBlackTree.Tree<A, X> a, RedBlackTree.Tree<A, Y> b, Ordering<A> evidence$13) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return a.count() == b.count() && new RedBlackTree.EqualsIterator<A, Y>(a, evidence$13).sameKeys(new RedBlackTree.EqualsIterator<A, Y>(b, evidence$13));
    }

    public <A, X, Y> boolean valuesEqual(RedBlackTree.Tree<A, X> a, RedBlackTree.Tree<A, Y> b, Ordering<A> evidence$14) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return a.count() == b.count() && new RedBlackTree.EqualsIterator<A, Y>(a, evidence$14).sameValues(new RedBlackTree.EqualsIterator<A, Y>(b, evidence$14));
    }

    public <A, X, Y> boolean entriesEqual(RedBlackTree.Tree<A, X> a, RedBlackTree.Tree<A, Y> b, Ordering<A> evidence$15) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return a.count() == b.count() && new RedBlackTree.EqualsIterator<A, Y>(a, evidence$15).sameEntries(new RedBlackTree.EqualsIterator<A, Y>(b, evidence$15));
    }

    private <A, B, U> void _foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        while (true) {
            if (tree.left() != null) {
                this._foreach(tree.left(), f);
            }
            f.apply(new Tuple2<A, B>(tree.key(), tree.value()));
            if (tree.right() == null) break;
            tree = tree.right();
        }
    }

    public <A, U> void foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        if (tree != null) {
            RedBlackTree.Tree<A, ?> _foreachKey_tree = tree;
            while (true) {
                if (_foreachKey_tree.left() != null) {
                    this._foreachKey(_foreachKey_tree.left(), f);
                }
                f.apply(_foreachKey_tree.key());
                if (_foreachKey_tree.right() == null) break;
                _foreachKey_tree = _foreachKey_tree.right();
            }
        }
    }

    private <A, U> void _foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        while (true) {
            if (tree.left() != null) {
                this._foreachKey(tree.left(), f);
            }
            f.apply(tree.key());
            if (tree.right() == null) break;
            tree = tree.right();
        }
    }

    public <A, B, U> void foreachEntry(RedBlackTree.Tree<A, B> tree, Function2<A, B, U> f) {
        if (tree != null) {
            RedBlackTree.Tree<A, B> _foreachEntry_tree = tree;
            while (true) {
                if (_foreachEntry_tree.left() != null) {
                    this._foreachEntry(_foreachEntry_tree.left(), f);
                }
                f.apply(_foreachEntry_tree.key(), _foreachEntry_tree.value());
                if (_foreachEntry_tree.right() == null) break;
                _foreachEntry_tree = _foreachEntry_tree.right();
            }
        }
    }

    private <A, B, U> void _foreachEntry(RedBlackTree.Tree<A, B> tree, Function2<A, B, U> f) {
        while (true) {
            if (tree.left() != null) {
                this._foreachEntry(tree.left(), f);
            }
            f.apply(tree.key(), tree.value());
            if (tree.right() == null) break;
            tree = tree.right();
        }
    }

    public <A, B> Iterator<Tuple2<A, B>> iterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$16) {
        return new RedBlackTree.EntriesIterator<A, B>(tree, start, evidence$16);
    }

    public <A, B> None$ iterator$default$2() {
        return None$.MODULE$;
    }

    public <A> Iterator<A> keysIterator(RedBlackTree.Tree<A, ?> tree, Option<A> start, Ordering<A> evidence$17) {
        return new RedBlackTree.KeysIterator(tree, start, evidence$17);
    }

    public <A> None$ keysIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> Iterator<B> valuesIterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$18) {
        return new RedBlackTree.ValuesIterator<A, B>(tree, start, evidence$18);
    }

    public <A, B> None$ valuesIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> RedBlackTree.Tree<A, B> nth(RedBlackTree.Tree<A, B> tree, int n) {
        while (true) {
            int count;
            if (n < (count = this.count(tree.left()))) {
                tree = tree.left();
                continue;
            }
            if (n <= count) break;
            n = n - count - 1;
            tree = tree.right();
        }
        return tree;
    }

    public boolean isBlack(RedBlackTree.Tree<?, ?> tree) {
        return tree == null || tree instanceof RedBlackTree.BlackTree;
    }

    private boolean isRedTree(RedBlackTree.Tree<?, ?> tree) {
        return tree instanceof RedBlackTree.RedTree;
    }

    public boolean scala$collection$immutable$RedBlackTree$$isBlackTree(RedBlackTree.Tree<?, ?> tree) {
        return tree instanceof RedBlackTree.BlackTree;
    }

    private <A, B> RedBlackTree.Tree<A, B> blacken(RedBlackTree.Tree<A, B> t) {
        if (t == null) {
            return null;
        }
        return t.black();
    }

    private <A, B> RedBlackTree.Tree<A, B> maybeBlacken(RedBlackTree.Tree<A, B> t) {
        if (this.isBlack(t)) {
            return t;
        }
        if (t.left() instanceof RedBlackTree.RedTree || t.right() instanceof RedBlackTree.RedTree) {
            return t.black();
        }
        return t;
    }

    private <A, B> RedBlackTree.Tree<A, B> mkTree(boolean isBlack, A k, B v, RedBlackTree.Tree<A, B> l, RedBlackTree.Tree<A, B> r) {
        if (isBlack) {
            return new RedBlackTree.BlackTree<A, B>(k, v, l, r);
        }
        return new RedBlackTree.RedTree<A, B>(k, v, l, r);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B1> RedBlackTree.Tree<A, B1> balanceLeft(RedBlackTree.Tree<A, B1> tree, RedBlackTree.Tree<A, B1> newLeft) {
        if (tree.left() == newLeft) {
            return tree;
        }
        A tree_key = tree.key();
        B1 tree_value = tree.value();
        RedBlackTree.Tree<A, B1> tree_right = tree.right();
        if (newLeft instanceof RedBlackTree.RedTree) {
            RedBlackTree.Tree<A, B1> newLeft_left = newLeft.left();
            RedBlackTree.Tree<A, B1> newLeft_right = newLeft.right();
            if (newLeft_left instanceof RedBlackTree.RedTree) {
                void apply_right;
                void apply_left;
                void apply_value;
                RedBlackTree.BlackTree<A, B1> blackTree;
                RedBlackTree.BlackTree<A, B1> blackTree2 = blackTree = new RedBlackTree.BlackTree<A, B1>(tree_key, tree_value, newLeft_right, tree_right);
                blackTree = null;
                RedBlackTree.BlackTree<A, B1> blackTree3 = blackTree2;
                RedBlackTree.Tree<A, B1> tree2 = newLeft_left.black();
                B1 B1 = newLeft.value();
                A apply_key = newLeft.key();
                return new RedBlackTree.RedTree<A, void>(apply_key, apply_value, apply_left, apply_right);
            }
            if (newLeft_right instanceof RedBlackTree.RedTree) {
                void apply_right;
                void apply_left;
                void apply_value;
                void apply_right2;
                void apply_value2;
                RedBlackTree.BlackTree<A, B1> blackTree;
                RedBlackTree.Tree<A, B1> tree3 = newLeft_right.left();
                B1 B1 = newLeft.value();
                A apply_key = newLeft.key();
                Object var13_15 = null;
                B1 = null;
                tree3 = null;
                RedBlackTree.Tree<A, B1> apply_left2 = newLeft_right.right();
                RedBlackTree.BlackTree<A, B1> blackTree4 = blackTree = new RedBlackTree.BlackTree<A, B1>(tree_key, tree_value, apply_left2, tree_right);
                Object var16_16 = null;
                blackTree = null;
                RedBlackTree.BlackTree<A, B1> blackTree5 = blackTree4;
                RedBlackTree.BlackTree<A, void> blackTree6 = new RedBlackTree.BlackTree<A, void>(apply_key, apply_value2, newLeft_left, apply_right2);
                B1 B12 = newLeft_right.value();
                A apply_key2 = newLeft_right.key();
                return new RedBlackTree.RedTree<A, void>(apply_key2, apply_value, apply_left, apply_right);
            }
            return this.mkTree(this.isBlack(tree), tree_key, tree_value, newLeft, tree_right);
        }
        return this.mkTree(this.isBlack(tree), tree_key, tree_value, newLeft, tree_right);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B1> RedBlackTree.Tree<A, B1> balanceRight(RedBlackTree.Tree<A, B1> tree, RedBlackTree.Tree<A, B1> newRight) {
        if (tree.right() == newRight) {
            return tree;
        }
        A tree_key = tree.key();
        B1 tree_value = tree.value();
        RedBlackTree.Tree<A, B1> tree_left = tree.left();
        if (newRight instanceof RedBlackTree.RedTree) {
            RedBlackTree.Tree<A, B1> newRight_left = newRight.left();
            RedBlackTree.Tree<A, B1> newRight_right = newRight.right();
            if (newRight_left instanceof RedBlackTree.RedTree) {
                void apply_right;
                void apply_left;
                void apply_value;
                void apply_left2;
                void apply_value2;
                RedBlackTree.BlackTree<A, void> blackTree;
                RedBlackTree.Tree<A, B1> apply_right2 = newRight_left.left();
                Object var8_8 = null;
                RedBlackTree.Tree<A, B1> tree2 = newRight_left.right();
                B1 B1 = newRight.value();
                A apply_key = newRight.key();
                RedBlackTree.BlackTree<A, void> blackTree2 = blackTree = new RedBlackTree.BlackTree<A, void>(apply_key, apply_value2, apply_left2, newRight_right);
                Object var9_11 = null;
                B1 = null;
                tree2 = null;
                blackTree = null;
                RedBlackTree.BlackTree<A, void> blackTree3 = blackTree2;
                RedBlackTree.BlackTree<A, B1> blackTree4 = new RedBlackTree.BlackTree<A, B1>(tree_key, tree_value, tree_left, apply_right2);
                B1 B12 = newRight_left.value();
                A apply_key2 = newRight_left.key();
                return new RedBlackTree.RedTree<A, void>(apply_key2, apply_value, apply_left, apply_right);
            }
            if (newRight_right instanceof RedBlackTree.RedTree) {
                void apply_right;
                void apply_left;
                void apply_value;
                RedBlackTree.Tree<A, B1> tree3 = newRight_right.black();
                RedBlackTree.BlackTree<A, B1> blackTree = new RedBlackTree.BlackTree<A, B1>(tree_key, tree_value, tree_left, newRight_left);
                B1 B1 = newRight.value();
                A apply_key = newRight.key();
                return new RedBlackTree.RedTree<A, void>(apply_key, apply_value, apply_left, apply_right);
            }
            return this.mkTree(this.isBlack(tree), tree_key, tree_value, tree_left, newRight);
        }
        return this.mkTree(this.isBlack(tree), tree_key, tree_value, tree_left, newRight);
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> upd(RedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> ordering) {
        if (tree == null) {
            return new RedBlackTree.RedTree<A, B1>(k, v, null, null);
        }
        int cmp = ordering.compare(k, tree.key());
        if (cmp < 0) {
            return this.balanceLeft(tree, this.upd(tree.left(), k, v, overwrite, ordering));
        }
        if (cmp > 0) {
            return this.balanceRight(tree, this.upd(tree.right(), k, v, overwrite, ordering));
        }
        if (overwrite && v != tree.value()) {
            return this.mkTree(tree instanceof RedBlackTree.BlackTree, tree.key(), v, tree.left(), tree.right());
        }
        return tree;
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> updNth(RedBlackTree.Tree<A, B> tree, int idx, A k, B1 v) {
        if (tree == null) {
            return new RedBlackTree.RedTree<A, B1>(k, v, null, null);
        }
        int rank = this.count(tree.left()) + 1;
        if (idx < rank) {
            return this.balanceLeft(tree, this.updNth(tree.left(), idx, k, v));
        }
        if (idx > rank) {
            return this.balanceRight(tree, this.updNth(tree.right(), idx - rank, k, v));
        }
        return tree;
    }

    private <A, B> RedBlackTree.Tree<A, B> doFrom(RedBlackTree.Tree<A, B> tree, A from, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(tree.key(), from)) {
            return this.doFrom(tree.right(), from, ordering);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree.left(), from, ordering);
        if (newLeft == tree.left()) {
            return tree;
        }
        if (newLeft == null) {
            return this.upd(tree.right(), tree.key(), tree.value(), false, ordering);
        }
        return this.join(newLeft, tree.key(), tree.value(), tree.right());
    }

    private <A, B> RedBlackTree.Tree<A, B> doTo(RedBlackTree.Tree<A, B> tree, A to, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(to, tree.key())) {
            return this.doTo(tree.left(), to, ordering);
        }
        RedBlackTree.Tree<A, B> newRight = this.doTo(tree.right(), to, ordering);
        if (newRight == tree.right()) {
            return tree;
        }
        if (newRight == null) {
            return this.upd(tree.left(), tree.key(), tree.value(), false, ordering);
        }
        return this.join(tree.left(), tree.key(), tree.value(), newRight);
    }

    private <A, B> RedBlackTree.Tree<A, B> doUntil(RedBlackTree.Tree<A, B> tree, A until, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lteq(until, tree.key())) {
            return this.doUntil(tree.left(), until, ordering);
        }
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree.right(), until, ordering);
        if (newRight == tree.right()) {
            return tree;
        }
        if (newRight == null) {
            return this.upd(tree.left(), tree.key(), tree.value(), false, ordering);
        }
        return this.join(tree.left(), tree.key(), tree.value(), newRight);
    }

    private <A, B> RedBlackTree.Tree<A, B> doRange(RedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(tree.key(), from)) {
            return this.doRange(tree.right(), from, until, ordering);
        }
        if (ordering.lteq(until, tree.key())) {
            return this.doRange(tree.left(), from, until, ordering);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree.left(), from, ordering);
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree.right(), until, ordering);
        if (newLeft == tree.left() && newRight == tree.right()) {
            return tree;
        }
        if (newLeft == null) {
            return this.upd(newRight, tree.key(), tree.value(), false, ordering);
        }
        if (newRight == null) {
            return this.upd(newLeft, tree.key(), tree.value(), false, ordering);
        }
        return this.join(newLeft, tree.key(), tree.value(), newRight);
    }

    private <A, B> RedBlackTree.Tree<A, B> doDrop(RedBlackTree.Tree<A, B> tree, int n) {
        int l;
        while (true) {
            if (tree == null || n <= 0) {
                return tree;
            }
            if (n >= tree.count()) {
                return null;
            }
            l = this.count(tree.left());
            if (n <= l) break;
            n = n - l - 1;
            tree = tree.right();
        }
        if (n == l) {
            return this.join(null, tree.key(), tree.value(), tree.right());
        }
        return this.join(this.doDrop(tree.left(), n), tree.key(), tree.value(), tree.right());
    }

    private <A, B> RedBlackTree.Tree<A, B> doTake(RedBlackTree.Tree<A, B> tree, int n) {
        int l;
        while (true) {
            if (tree == null || n <= 0) {
                return null;
            }
            if (n >= tree.count()) {
                return tree;
            }
            l = this.count(tree.left());
            if (n > l) break;
            tree = tree.left();
        }
        if (n == l + 1) {
            return this.maybeBlacken(this.updNth(tree.left(), n, tree.key(), tree.value()));
        }
        return this.join(tree.left(), tree.key(), tree.value(), this.doTake(tree.right(), n - l - 1));
    }

    private <A, B> RedBlackTree.Tree<A, B> doSlice(RedBlackTree.Tree<A, B> tree, int from, int until) {
        int l;
        while (true) {
            if (tree == null || from >= until || from >= tree.count() || until <= 0) {
                return null;
            }
            if (from <= 0 && until >= tree.count()) {
                return tree;
            }
            l = this.count(tree.left());
            if (until <= l) {
                tree = tree.left();
                continue;
            }
            if (from <= l) break;
            until = until - l - 1;
            from = from - l - 1;
            tree = tree.right();
        }
        return this.join(this.doDrop(tree.left(), from), tree.key(), tree.value(), this.doTake(tree.right(), until - l - 1));
    }

    public <A> RedBlackTree.Tree<A, Null$> fromOrderedKeys(Iterator<A> xs, int size) {
        int maxUsedDepth = 32 - Integer.numberOfLeadingZeros(size);
        return this.f$1(1, size, maxUsedDepth, xs);
    }

    public <A, B> RedBlackTree.Tree<A, B> fromOrderedEntries(Iterator<Tuple2<A, B>> xs, int size) {
        int maxUsedDepth = 32 - Integer.numberOfLeadingZeros(size);
        return this.f$2(1, size, xs, maxUsedDepth);
    }

    public <A, B, C> RedBlackTree.Tree<A, C> transform(RedBlackTree.Tree<A, B> t, Function2<A, B, C> f) {
        if (t == null) {
            return null;
        }
        A k = t.key();
        B v = t.value();
        RedBlackTree.Tree<A, B> l = t.left();
        RedBlackTree.Tree<A, B> r = t.right();
        RedBlackTree.Tree<A, C> l2 = this.transform(l, f);
        C v2 = f.apply(k, v);
        RedBlackTree.Tree<A, C> r2 = this.transform(r, f);
        if (v2 == v && l2 == l && r2 == r) {
            return t;
        }
        return this.mkTree(t instanceof RedBlackTree.BlackTree, k, v2, l2, r2);
    }

    public <A, B> RedBlackTree.Tree<A, B> filterEntries(RedBlackTree.Tree<A, B> t, Function2<A, B, Object> f) {
        RedBlackTree.Tree fk$1_r2;
        if (t == null) {
            return null;
        }
        A fk$1_k = t.key();
        B fk$1_v = t.value();
        RedBlackTree.Tree<A, B> fk$1_l = t.left();
        RedBlackTree.Tree<A, B> fk$1_r = t.right();
        RedBlackTree.Tree fk$1_l2 = fk$1_l == null ? null : this.fk$1(fk$1_l, f);
        boolean fk$1_keep = BoxesRunTime.unboxToBoolean(f.apply(fk$1_k, fk$1_v));
        RedBlackTree.Tree tree = fk$1_r2 = fk$1_r == null ? null : this.fk$1(fk$1_r, f);
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        Object var9_9 = null;
        return this.blacken(!fk$1_keep ? this.join2(fk$1_l2, fk$1_r2) : (fk$1_l2 == fk$1_l && fk$1_r2 == fk$1_r ? t : this.join(fk$1_l2, fk$1_k, fk$1_v, fk$1_r2)));
    }

    public <A, B> RedBlackTree.Tree<A, B> filterKeys(RedBlackTree.Tree<A, B> t, Function1<A, Object> f) {
        RedBlackTree.Tree fk$2_r2;
        if (t == null) {
            return null;
        }
        A fk$2_k = t.key();
        RedBlackTree.Tree<A, B> fk$2_l = t.left();
        RedBlackTree.Tree<A, B> fk$2_r = t.right();
        RedBlackTree.Tree fk$2_l2 = fk$2_l == null ? null : this.fk$2(fk$2_l, f);
        boolean fk$2_keep = BoxesRunTime.unboxToBoolean(f.apply(fk$2_k));
        RedBlackTree.Tree tree = fk$2_r2 = fk$2_r == null ? null : this.fk$2(fk$2_r, f);
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Object var8_8 = null;
        return this.blacken(!fk$2_keep ? this.join2(fk$2_l2, fk$2_r2) : (fk$2_l2 == fk$2_l && fk$2_r2 == fk$2_r ? t : this.join(fk$2_l2, fk$2_k, t.value(), fk$2_r2)));
    }

    public <A, B> Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> partitionEntries(RedBlackTree.Tree<A, B> t, Function2<A, B, Object> p) {
        RedBlackTree.Tree<A, B> fk$3_jk;
        ObjectRef<Object> objectRef;
        ObjectRef<Object> objectRef2;
        if (t == null) {
            return new Tuple2<Object, Object>(null, null);
        }
        ObjectRef<Object> objectRef3 = objectRef2 = new ObjectRef<Object>(null);
        objectRef2 = null;
        ObjectRef<Object> tmpk = objectRef3;
        ObjectRef<Object> objectRef4 = objectRef = new ObjectRef<Object>(null);
        objectRef = null;
        ObjectRef<Object> tmpd = objectRef4;
        A fk$3_k = t.key();
        B fk$3_v = t.value();
        RedBlackTree.Tree<A, B> fk$3_l = t.left();
        RedBlackTree.Tree<A, B> fk$3_r = t.right();
        RedBlackTree.Tree fk$3_l2k = null;
        RedBlackTree.Tree fk$3_l2d = null;
        RedBlackTree.Tree fk$3_r2k = null;
        RedBlackTree.Tree fk$3_r2d = null;
        if (fk$3_l != null) {
            this.fk$3(fk$3_l, tmpk, tmpd, p);
            fk$3_l2k = (RedBlackTree.Tree)tmpk.elem;
            fk$3_l2d = (RedBlackTree.Tree)tmpd.elem;
        }
        boolean fk$3_keep = BoxesRunTime.unboxToBoolean(p.apply(fk$3_k, fk$3_v));
        if (fk$3_r != null) {
            this.fk$3(fk$3_r, tmpk, tmpd, p);
            fk$3_r2k = (RedBlackTree.Tree)tmpk.elem;
            fk$3_r2d = (RedBlackTree.Tree)tmpd.elem;
        }
        RedBlackTree.Tree<A, B> tree = !fk$3_keep ? this.join2(fk$3_l2k, fk$3_r2k) : (fk$3_jk = fk$3_l2k == fk$3_l && fk$3_r2k == fk$3_r ? t : this.join(fk$3_l2k, fk$3_k, fk$3_v, fk$3_r2k));
        RedBlackTree.Tree<A, B> fk$3_jd = fk$3_keep ? this.join2(fk$3_l2d, fk$3_r2d) : (fk$3_l2d == fk$3_l && fk$3_r2d == fk$3_r ? t : this.join(fk$3_l2d, fk$3_k, fk$3_v, fk$3_r2d));
        tmpk.elem = fk$3_jk;
        tmpd.elem = fk$3_jd;
        Object var5_7 = null;
        Object var6_8 = null;
        Object var7_9 = null;
        Object var8_10 = null;
        Object var9_11 = null;
        Object var10_12 = null;
        Object var11_13 = null;
        Object var12_14 = null;
        Object var14_16 = null;
        Object var15_17 = null;
        return new Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>>(this.blacken((RedBlackTree.Tree)tmpk.elem), this.blacken((RedBlackTree.Tree)tmpd.elem));
    }

    public <A, B> Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> partitionKeys(RedBlackTree.Tree<A, B> t, Function1<A, Object> p) {
        RedBlackTree.Tree<A, B> fk$4_jk;
        ObjectRef<Object> objectRef;
        ObjectRef<Object> objectRef2;
        if (t == null) {
            return new Tuple2<Object, Object>(null, null);
        }
        ObjectRef<Object> objectRef3 = objectRef2 = new ObjectRef<Object>(null);
        objectRef2 = null;
        ObjectRef<Object> tmpk = objectRef3;
        ObjectRef<Object> objectRef4 = objectRef = new ObjectRef<Object>(null);
        objectRef = null;
        ObjectRef<Object> tmpd = objectRef4;
        A fk$4_k = t.key();
        B fk$4_v = t.value();
        RedBlackTree.Tree<A, B> fk$4_l = t.left();
        RedBlackTree.Tree<A, B> fk$4_r = t.right();
        RedBlackTree.Tree fk$4_l2k = null;
        RedBlackTree.Tree fk$4_l2d = null;
        RedBlackTree.Tree fk$4_r2k = null;
        RedBlackTree.Tree fk$4_r2d = null;
        if (fk$4_l != null) {
            this.fk$4(fk$4_l, tmpk, tmpd, p);
            fk$4_l2k = (RedBlackTree.Tree)tmpk.elem;
            fk$4_l2d = (RedBlackTree.Tree)tmpd.elem;
        }
        boolean fk$4_keep = BoxesRunTime.unboxToBoolean(p.apply(fk$4_k));
        if (fk$4_r != null) {
            this.fk$4(fk$4_r, tmpk, tmpd, p);
            fk$4_r2k = (RedBlackTree.Tree)tmpk.elem;
            fk$4_r2d = (RedBlackTree.Tree)tmpd.elem;
        }
        RedBlackTree.Tree<A, B> tree = !fk$4_keep ? this.join2(fk$4_l2k, fk$4_r2k) : (fk$4_jk = fk$4_l2k == fk$4_l && fk$4_r2k == fk$4_r ? t : this.join(fk$4_l2k, fk$4_k, fk$4_v, fk$4_r2k));
        RedBlackTree.Tree<A, B> fk$4_jd = fk$4_keep ? this.join2(fk$4_l2d, fk$4_r2d) : (fk$4_l2d == fk$4_l && fk$4_r2d == fk$4_r ? t : this.join(fk$4_l2d, fk$4_k, fk$4_v, fk$4_r2d));
        tmpk.elem = fk$4_jk;
        tmpd.elem = fk$4_jd;
        Object var5_7 = null;
        Object var6_8 = null;
        Object var7_9 = null;
        Object var8_10 = null;
        Object var9_11 = null;
        Object var10_12 = null;
        Object var11_13 = null;
        Object var12_14 = null;
        Object var14_16 = null;
        Object var15_17 = null;
        return new Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>>(this.blacken((RedBlackTree.Tree)tmpk.elem), this.blacken((RedBlackTree.Tree)tmpd.elem));
    }

    private <A, B> RedBlackTree.Tree<A, B> del(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        int cmp = ordering.compare(k, tree.key());
        if (cmp < 0) {
            return this.delLeft$1(tree, k, ordering);
        }
        if (cmp > 0) {
            return this.delRight$1(tree, k, ordering);
        }
        return this.append(tree.left(), tree.right());
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> RedBlackTree.Tree<A, B> balance(A x, B xv, RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        if (tl instanceof RedBlackTree.RedTree) {
            if (tr instanceof RedBlackTree.RedTree) {
                void apply_right;
                RedBlackTree.Tree<A, B> tree = tr.black();
                RedBlackTree.Tree<A, B> apply_left = tl.black();
                return new RedBlackTree.RedTree<A, B>(x, xv, apply_left, apply_right);
            }
            if (tl.left() instanceof RedBlackTree.RedTree) {
                void apply_right;
                void apply_left;
                void apply_value;
                RedBlackTree.BlackTree<A, B> blackTree;
                RedBlackTree.Tree<A, B> apply_left2 = tl.right();
                RedBlackTree.BlackTree<A, B> blackTree2 = blackTree = new RedBlackTree.BlackTree<A, B>(x, xv, apply_left2, tr);
                Object var7_7 = null;
                blackTree = null;
                RedBlackTree.BlackTree<A, B> blackTree3 = blackTree2;
                RedBlackTree.Tree<A, B> tree = tl.left().black();
                B b = tl.value();
                A apply_key = tl.key();
                return new RedBlackTree.RedTree<A, void>(apply_key, apply_value, apply_left, apply_right);
            }
            if (tl.right() instanceof RedBlackTree.RedTree) {
                void apply_right;
                void apply_left;
                void apply_value;
                void apply_right2;
                void apply_left3;
                void apply_value2;
                RedBlackTree.BlackTree<A, B> blackTree;
                RedBlackTree.Tree<A, B> tree = tl.right().left();
                RedBlackTree.Tree<A, B> tree2 = tl.left();
                B b = tl.value();
                A apply_key = tl.key();
                Object var13_16 = null;
                b = null;
                tree2 = null;
                tree = null;
                RedBlackTree.Tree<A, B> apply_left4 = tl.right().right();
                RedBlackTree.BlackTree<A, B> blackTree4 = blackTree = new RedBlackTree.BlackTree<A, B>(x, xv, apply_left4, tr);
                Object var17_17 = null;
                blackTree = null;
                RedBlackTree.BlackTree<A, B> blackTree5 = blackTree4;
                RedBlackTree.BlackTree<A, void> blackTree6 = new RedBlackTree.BlackTree<A, void>(apply_key, apply_value2, apply_left3, apply_right2);
                B b2 = tl.right().value();
                A apply_key2 = tl.right().key();
                return new RedBlackTree.RedTree<A, void>(apply_key2, apply_value, apply_left, apply_right);
            }
            return new RedBlackTree.BlackTree<A, B>(x, xv, tl, tr);
        }
        if (tr instanceof RedBlackTree.RedTree) {
            if (tr.right() instanceof RedBlackTree.RedTree) {
                void apply_right;
                void apply_left;
                void apply_value;
                RedBlackTree.Tree<A, B> apply_right3 = tr.left();
                Object var23_23 = null;
                RedBlackTree.Tree<A, B> tree = tr.right().black();
                RedBlackTree.BlackTree<A, B> blackTree = new RedBlackTree.BlackTree<A, B>(x, xv, tl, apply_right3);
                B b = tr.value();
                A apply_key = tr.key();
                return new RedBlackTree.RedTree<A, void>(apply_key, apply_value, apply_left, apply_right);
            }
            if (tr.left() instanceof RedBlackTree.RedTree) {
                void apply_right;
                void apply_left;
                void apply_value;
                void apply_right4;
                void apply_left5;
                void apply_value3;
                RedBlackTree.BlackTree<A, void> blackTree;
                RedBlackTree.Tree<A, B> apply_right5 = tr.left().left();
                Object var28_28 = null;
                RedBlackTree.Tree<A, B> tree = tr.right();
                RedBlackTree.Tree<A, B> tree3 = tr.left().right();
                B b = tr.value();
                A apply_key = tr.key();
                RedBlackTree.BlackTree<A, void> blackTree7 = blackTree = new RedBlackTree.BlackTree<A, void>(apply_key, apply_value3, apply_left5, apply_right4);
                Object var29_32 = null;
                b = null;
                tree3 = null;
                tree = null;
                blackTree = null;
                RedBlackTree.BlackTree<A, void> blackTree8 = blackTree7;
                RedBlackTree.BlackTree<A, B> blackTree9 = new RedBlackTree.BlackTree<A, B>(x, xv, tl, apply_right5);
                B b3 = tr.left().value();
                A apply_key3 = tr.left().key();
                return new RedBlackTree.RedTree<A, void>(apply_key3, apply_value, apply_left, apply_right);
            }
            return new RedBlackTree.BlackTree<A, B>(x, xv, tl, tr);
        }
        return new RedBlackTree.BlackTree<A, B>(x, xv, tl, tr);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> RedBlackTree.Tree<A, B> balLeft(A x, B xv, RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        if (tl instanceof RedBlackTree.RedTree) {
            RedBlackTree.Tree<A, B> apply_left = tl.black();
            return new RedBlackTree.RedTree<A, B>(x, xv, apply_left, tr);
        }
        if (tr instanceof RedBlackTree.BlackTree) {
            return this.balance(x, xv, tl, tr.red());
        }
        if (tr instanceof RedBlackTree.RedTree && tr.left() instanceof RedBlackTree.BlackTree) {
            void apply_right;
            void apply_left;
            void apply_value;
            RedBlackTree.Tree<A, B> apply_right2 = tr.left().left();
            Object var6_6 = null;
            RedBlackTree.Tree<A, B> tree = this.balance(tr.key(), tr.value(), tr.left().right(), tr.right().red());
            RedBlackTree.BlackTree<A, B> blackTree = new RedBlackTree.BlackTree<A, B>(x, xv, tl, apply_right2);
            B b = tr.left().value();
            A apply_key = tr.left().key();
            return new RedBlackTree.RedTree<A, void>(apply_key, apply_value, apply_left, apply_right);
        }
        String error_message = "Defect: invariance violation";
        throw new RuntimeException(error_message);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> RedBlackTree.Tree<A, B> balRight(A x, B xv, RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        if (tr instanceof RedBlackTree.RedTree) {
            RedBlackTree.Tree<A, B> apply_right = tr.black();
            return new RedBlackTree.RedTree<A, B>(x, xv, tl, apply_right);
        }
        if (tl instanceof RedBlackTree.BlackTree) {
            return this.balance(x, xv, tl.red(), tr);
        }
        if (tl instanceof RedBlackTree.RedTree && tl.right() instanceof RedBlackTree.BlackTree) {
            void apply_right;
            void apply_left;
            void apply_value;
            RedBlackTree.BlackTree<A, B> blackTree;
            RedBlackTree.Tree<A, B> apply_left2 = tl.right().right();
            RedBlackTree.BlackTree<A, B> blackTree2 = blackTree = new RedBlackTree.BlackTree<A, B>(x, xv, apply_left2, tr);
            Object var6_6 = null;
            blackTree = null;
            RedBlackTree.BlackTree<A, B> blackTree3 = blackTree2;
            RedBlackTree.Tree<A, B> tree = this.balance(tl.key(), tl.value(), tl.left().red(), tl.right().left());
            B b = tl.right().value();
            A apply_key = tl.right().key();
            return new RedBlackTree.RedTree<A, void>(apply_key, apply_value, apply_left, apply_right);
        }
        String error_message = "Defect: invariance violation";
        throw new RuntimeException(error_message);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> RedBlackTree.Tree<A, B> append(RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        if (tl == null) {
            return tr;
        }
        if (tr == null) {
            return tl;
        }
        if (tl instanceof RedBlackTree.RedTree && tr instanceof RedBlackTree.RedTree) {
            void apply_right;
            void apply_left;
            void apply_value;
            void apply_right2;
            void apply_value2;
            RedBlackTree.RedTree<A, void> redTree;
            RedBlackTree.Tree<A, B> bc = this.append(tl.right(), tr.left());
            if (bc instanceof RedBlackTree.RedTree) {
                void apply_right3;
                void apply_left2;
                void apply_value3;
                void apply_right4;
                void apply_left3;
                void apply_value4;
                void apply_right5;
                void apply_left4;
                void apply_value5;
                RedBlackTree.RedTree<A, void> redTree2;
                RedBlackTree.Tree<A, B> tree = bc.left();
                RedBlackTree.Tree<A, B> tree2 = tl.left();
                B b = tl.value();
                A apply_key = tl.key();
                Object var5_7 = null;
                b = null;
                tree2 = null;
                tree = null;
                RedBlackTree.Tree<A, B> tree3 = tr.right();
                RedBlackTree.Tree<A, B> tree4 = bc.right();
                B b2 = tr.value();
                A apply_key2 = tr.key();
                RedBlackTree.RedTree<A, void> redTree3 = redTree2 = new RedBlackTree.RedTree<A, void>(apply_key2, apply_value5, apply_left4, apply_right5);
                Object var9_11 = null;
                b2 = null;
                tree4 = null;
                tree3 = null;
                redTree2 = null;
                RedBlackTree.RedTree<A, void> redTree4 = redTree3;
                RedBlackTree.RedTree<A, void> redTree5 = new RedBlackTree.RedTree<A, void>(apply_key, apply_value4, apply_left3, apply_right4);
                B b3 = bc.value();
                A apply_key3 = bc.key();
                return new RedBlackTree.RedTree<A, void>(apply_key3, apply_value3, apply_left2, apply_right3);
            }
            RedBlackTree.Tree<A, B> tree = tr.right();
            B b = tr.value();
            A apply_key = tr.key();
            RedBlackTree.RedTree<A, void> redTree6 = redTree = new RedBlackTree.RedTree<A, void>(apply_key, apply_value2, bc, apply_right2);
            Object var18_19 = null;
            b = null;
            tree = null;
            redTree = null;
            RedBlackTree.RedTree<A, void> redTree7 = redTree6;
            RedBlackTree.Tree<A, B> tree5 = tl.left();
            B b4 = tl.value();
            A apply_key4 = tl.key();
            return new RedBlackTree.RedTree<A, void>(apply_key4, apply_value, apply_left, apply_right);
        }
        if (tl instanceof RedBlackTree.BlackTree && tr instanceof RedBlackTree.BlackTree) {
            void apply_right;
            void apply_value;
            RedBlackTree.Tree<A, B> bc = this.append(tl.right(), tr.left());
            if (bc instanceof RedBlackTree.RedTree) {
                void apply_right6;
                void apply_left;
                void apply_value6;
                void apply_right7;
                void apply_left5;
                void apply_value7;
                void apply_right8;
                void apply_left6;
                void apply_value8;
                RedBlackTree.BlackTree<A, void> blackTree;
                RedBlackTree.Tree<A, B> tree = bc.left();
                RedBlackTree.Tree<A, B> tree6 = tl.left();
                B b = tl.value();
                A apply_key = tl.key();
                Object var26_29 = null;
                b = null;
                tree6 = null;
                tree = null;
                RedBlackTree.Tree<A, B> tree7 = tr.right();
                RedBlackTree.Tree<A, B> tree8 = bc.right();
                B b5 = tr.value();
                A apply_key5 = tr.key();
                RedBlackTree.BlackTree<A, void> blackTree2 = blackTree = new RedBlackTree.BlackTree<A, void>(apply_key5, apply_value8, apply_left6, apply_right8);
                Object var30_33 = null;
                b5 = null;
                tree8 = null;
                tree7 = null;
                blackTree = null;
                RedBlackTree.BlackTree<A, void> blackTree3 = blackTree2;
                RedBlackTree.BlackTree<A, void> blackTree4 = new RedBlackTree.BlackTree<A, void>(apply_key, apply_value7, apply_left5, apply_right7);
                B b6 = bc.value();
                A apply_key6 = bc.key();
                return new RedBlackTree.RedTree<A, void>(apply_key6, apply_value6, apply_left, apply_right6);
            }
            RedBlackTree.Tree<A, B> tree = tr.right();
            B b = tr.value();
            A apply_key = tr.key();
            Object var39_41 = null;
            b = null;
            tree = null;
            return this.balLeft(tl.key(), tl.value(), tl.left(), new RedBlackTree.BlackTree<A, void>(apply_key, apply_value, bc, apply_right));
        }
        if (tr instanceof RedBlackTree.RedTree) {
            void apply_right;
            void apply_left;
            void apply_value;
            RedBlackTree.Tree<A, B> tree = tr.right();
            RedBlackTree.Tree<A, B> tree9 = this.append(tl, tr.left());
            B b = tr.value();
            A apply_key = tr.key();
            return new RedBlackTree.RedTree<A, void>(apply_key, apply_value, apply_left, apply_right);
        }
        if (tl instanceof RedBlackTree.RedTree) {
            void apply_right;
            void apply_left;
            void apply_value;
            RedBlackTree.Tree<A, B> tree = this.append(tl.right(), tr);
            RedBlackTree.Tree<A, B> tree10 = tl.left();
            B b = tl.value();
            A apply_key = tl.key();
            return new RedBlackTree.RedTree<A, void>(apply_key, apply_value, apply_left, apply_right);
        }
        String error_message = new StringBuilder(28).append("unmatched tree on append: ").append(tl).append(", ").append(tr).toString();
        throw new RuntimeException(error_message);
    }

    public <A, B> RedBlackTree.Tree<A, B> union(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        return this.blacken(this._union(t1, t2, ordering));
    }

    public <A, B> RedBlackTree.Tree<A, B> intersect(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        return this.blacken(this._intersect(t1, t2, ordering));
    }

    public <A, B> RedBlackTree.Tree<A, B> difference(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, ?> t2, Ordering<A> ordering) {
        return this.blacken(this._difference(t1, t2, ordering));
    }

    private int rank(RedBlackTree.Tree<?, ?> t, int bh) {
        if (t == null) {
            return 0;
        }
        if (t instanceof RedBlackTree.BlackTree) {
            return 2 * (bh - 1);
        }
        return 2 * bh - 1;
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> RedBlackTree.Tree<A, B> joinRight(RedBlackTree.Tree<A, B> tl, A k, B v, RedBlackTree.Tree<A, B> tr, int bhtl, int rtr) {
        if ((tl == null ? 0 : (tl instanceof RedBlackTree.BlackTree ? 2 * (bhtl - 1) : 2 * bhtl - 1)) == rtr / 2 * 2) {
            return new RedBlackTree.RedTree<A, B>(k, v, tl, tr);
        }
        boolean bl = tl instanceof RedBlackTree.BlackTree;
        int bhtlr = bl ? bhtl - 1 : bhtl;
        RedBlackTree.Tree<A, B> ttr = this.joinRight(tl.right(), k, v, tr, bhtlr, rtr);
        if (bl && ttr instanceof RedBlackTree.RedTree && ttr.right() instanceof RedBlackTree.RedTree) {
            void apply_right;
            void apply_left;
            void apply_value;
            void apply_right2;
            void apply_left2;
            void apply_value2;
            RedBlackTree.Tree<A, B> tree = ttr.left();
            RedBlackTree.Tree<A, B> tree2 = tl.left();
            B b = tl.value();
            A apply_key = tl.key();
            Object var10_13 = null;
            b = null;
            tree2 = null;
            tree = null;
            RedBlackTree.Tree<A, B> tree3 = ttr.right().black();
            RedBlackTree.BlackTree<A, void> blackTree = new RedBlackTree.BlackTree<A, void>(apply_key, apply_value2, apply_left2, apply_right2);
            B b2 = ttr.value();
            A apply_key2 = ttr.key();
            return new RedBlackTree.RedTree<A, void>(apply_key2, apply_value, apply_left, apply_right);
        }
        return this.mkTree(bl, tl.key(), tl.value(), tl.left(), ttr);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> RedBlackTree.Tree<A, B> joinLeft(RedBlackTree.Tree<A, B> tl, A k, B v, RedBlackTree.Tree<A, B> tr, int rtl, int bhtr) {
        if ((tr == null ? 0 : (tr instanceof RedBlackTree.BlackTree ? 2 * (bhtr - 1) : 2 * bhtr - 1)) == rtl / 2 * 2) {
            return new RedBlackTree.RedTree<A, B>(k, v, tl, tr);
        }
        boolean bl = tr instanceof RedBlackTree.BlackTree;
        int bhtrl = bl ? bhtr - 1 : bhtr;
        RedBlackTree.Tree<A, B> ttl = this.joinLeft(tl, k, v, tr.left(), rtl, bhtrl);
        if (bl && ttl instanceof RedBlackTree.RedTree && ttl.left() instanceof RedBlackTree.RedTree) {
            void apply_right;
            void apply_left;
            void apply_value;
            void apply_right2;
            void apply_left2;
            void apply_value2;
            RedBlackTree.BlackTree<A, void> blackTree;
            RedBlackTree.Tree<A, B> tree = tr.right();
            RedBlackTree.Tree<A, B> tree2 = ttl.right();
            B b = tr.value();
            A apply_key = tr.key();
            RedBlackTree.BlackTree<A, void> blackTree2 = blackTree = new RedBlackTree.BlackTree<A, void>(apply_key, apply_value2, apply_left2, apply_right2);
            Object var10_13 = null;
            b = null;
            tree2 = null;
            tree = null;
            blackTree = null;
            RedBlackTree.BlackTree<A, void> blackTree3 = blackTree2;
            RedBlackTree.Tree<A, B> tree3 = ttl.left().black();
            B b2 = ttl.value();
            A apply_key2 = ttl.key();
            return new RedBlackTree.RedTree<A, void>(apply_key2, apply_value, apply_left, apply_right);
        }
        return this.mkTree(bl, tr.key(), tr.value(), ttl, tr.right());
    }

    private <A, B> RedBlackTree.Tree<A, B> join(RedBlackTree.Tree<A, B> tl, A k, B v, RedBlackTree.Tree<A, B> tr) {
        int bhtr;
        int bhtl = this.h$1(tl, 0);
        if (bhtl > (bhtr = this.h$1(tr, 0))) {
            RedBlackTree.Tree<A, B> tt = this.joinRight(tl, k, v, tr, bhtl, tr == null ? 0 : (tr instanceof RedBlackTree.BlackTree ? 2 * (bhtr - 1) : 2 * bhtr - 1));
            if (tt instanceof RedBlackTree.RedTree && tt.right() instanceof RedBlackTree.RedTree) {
                return tt.black();
            }
            return tt;
        }
        if (bhtr > bhtl) {
            RedBlackTree.Tree<A, B> tt = this.joinLeft(tl, k, v, tr, tl == null ? 0 : (tl instanceof RedBlackTree.BlackTree ? 2 * (bhtl - 1) : 2 * bhtl - 1), bhtr);
            if (tt instanceof RedBlackTree.RedTree && tt.left() instanceof RedBlackTree.RedTree) {
                return tt.black();
            }
            return tt;
        }
        return this.mkTree(tl instanceof RedBlackTree.RedTree || tr instanceof RedBlackTree.RedTree, k, v, tl, tr);
    }

    private <A, B> Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> split(RedBlackTree.Tree<A, B> t, A k2, Ordering<A> ordering) {
        if (t == null) {
            return new Tuple4<Object, Object, Object, A>(null, null, null, k2);
        }
        int cmp = ordering.compare(k2, t.key());
        if (cmp == 0) {
            return new Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A>(t.left(), t, t.right(), t.key());
        }
        if (cmp < 0) {
            Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple4 = this.split(t.left(), k2, ordering);
            if (tuple4 == null) {
                throw new MatchError((Object)null);
            }
            RedBlackTree.Tree<A, B> tree = tuple4._1();
            RedBlackTree.Tree<A, B> tree2 = tuple4._2();
            RedBlackTree.Tree<A, B> tree3 = tuple4._3();
            A a = tuple4._4();
            return new Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A>(tree, tree2, this.join(tree3, t.key(), t.value(), t.right()), a);
        }
        Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple4 = this.split(t.right(), k2, ordering);
        if (tuple4 == null) {
            throw new MatchError((Object)null);
        }
        RedBlackTree.Tree<A, B> tree = tuple4._1();
        RedBlackTree.Tree<A, B> tree4 = tuple4._2();
        RedBlackTree.Tree<A, B> tree5 = tuple4._3();
        A a = tuple4._4();
        return new Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A>(this.join(t.left(), t.key(), t.value(), tree), tree4, tree5, a);
    }

    private <A, B> Tuple3<RedBlackTree.Tree<A, B>, A, B> splitLast(RedBlackTree.Tree<A, B> t) {
        if (t.right() == null) {
            return new Tuple3<RedBlackTree.Tree<A, B>, A, B>(t.left(), t.key(), t.value());
        }
        Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple3 = this.splitLast(t.right());
        if (tuple3 == null) {
            throw new MatchError((Object)null);
        }
        RedBlackTree.Tree<A, B> tree = tuple3._1();
        A a = tuple3._2();
        B b = tuple3._3();
        return new Tuple3<RedBlackTree.Tree<A, B>, A, B>(this.join(t.left(), t.key(), t.value(), tree), a, b);
    }

    private <A, B> RedBlackTree.Tree<A, B> join2(RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        if (tl == null) {
            return tr;
        }
        if (tr == null) {
            return tl;
        }
        Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple3 = this.splitLast(tl);
        if (tuple3 == null) {
            throw new MatchError((Object)null);
        }
        RedBlackTree.Tree<A, B> tree = tuple3._1();
        A a = tuple3._2();
        B b = tuple3._3();
        return this.join(tree, a, b, tr);
    }

    private <A, B> RedBlackTree.Tree<A, B> _union(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        if (t1 == null || t1 == t2) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple4 = this.split(t1, t2.key(), ordering);
        if (tuple4 == null) {
            throw new MatchError((Object)null);
        }
        RedBlackTree.Tree<A, B> tree = tuple4._1();
        RedBlackTree.Tree<A, B> tree2 = tuple4._3();
        A a = tuple4._4();
        RedBlackTree.Tree<A, B> tl = this._union(tree, t2.left(), ordering);
        RedBlackTree.Tree<A, B> tr = this._union(tree2, t2.right(), ordering);
        return this.join(tl, a, t2.value(), tr);
    }

    private <A, B> RedBlackTree.Tree<A, B> _intersect(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        if (t1 == null || t2 == null) {
            return null;
        }
        if (t1 == t2) {
            return t1;
        }
        Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple4 = this.split(t1, t2.key(), ordering);
        if (tuple4 == null) {
            throw new MatchError((Object)null);
        }
        RedBlackTree.Tree<A, B> tree = tuple4._1();
        RedBlackTree.Tree<A, B> tree2 = tuple4._2();
        RedBlackTree.Tree<A, B> tree3 = tuple4._3();
        A a = tuple4._4();
        RedBlackTree.Tree<A, B> tl = this._intersect(tree, t2.left(), ordering);
        RedBlackTree.Tree<A, B> tr = this._intersect(tree3, t2.right(), ordering);
        if (tree2 != null) {
            return this.join(tl, a, t2.value(), tr);
        }
        return this.join2(tl, tr);
    }

    private <A, B> RedBlackTree.Tree<A, B> _difference(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        if (t1 == null || t2 == null) {
            return t1;
        }
        if (t1 == t2) {
            return null;
        }
        Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple4 = this.split(t1, t2.key(), ordering);
        if (tuple4 == null) {
            throw new MatchError((Object)null);
        }
        RedBlackTree.Tree<A, B> tree = tuple4._1();
        RedBlackTree.Tree<A, B> tree2 = tuple4._3();
        tuple4._4();
        RedBlackTree.Tree<A, B> tl = this._difference(tree, t2.left(), ordering);
        RedBlackTree.Tree<A, B> tr = this._difference(tree2, t2.right(), ordering);
        return this.join2(tl, tr);
    }

    /*
     * WARNING - void declaration
     */
    private final RedBlackTree.Tree _tail$1(RedBlackTree.Tree tree) {
        void apply_right;
        void apply_left;
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        if (tree.left() == null) {
            return tree.right();
        }
        if (tree.left() instanceof RedBlackTree.BlackTree) {
            return this.balLeft(tree.key(), tree.value(), this._tail$1(tree.left()), tree.right());
        }
        RedBlackTree.Tree tree2 = tree.right();
        RedBlackTree.Tree tree3 = this._tail$1(tree.left());
        Object apply_value = tree.value();
        Object apply_key = tree.key();
        return new RedBlackTree.RedTree(apply_key, apply_value, apply_left, apply_right);
    }

    /*
     * WARNING - void declaration
     */
    private final RedBlackTree.Tree _init$1(RedBlackTree.Tree tree) {
        void apply_right;
        void apply_left;
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        if (tree.right() == null) {
            return tree.left();
        }
        if (tree.right() instanceof RedBlackTree.BlackTree) {
            return this.balRight(tree.key(), tree.value(), tree.left(), this._init$1(tree.right()));
        }
        RedBlackTree.Tree tree2 = this._init$1(tree.right());
        RedBlackTree.Tree tree3 = tree.left();
        Object apply_value = tree.value();
        Object apply_key = tree.key();
        return new RedBlackTree.RedTree(apply_key, apply_value, apply_left, apply_right);
    }

    private final RedBlackTree.Tree f$1(int level, int size, int maxUsedDepth$1, Iterator xs$1) {
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return this.mkTree(level != maxUsedDepth$1 || level == 1, xs$1.next(), null, null, null);
            }
        }
        int leftSize = (size - 1) / 2;
        RedBlackTree.Tree left = this.f$1(level + 1, leftSize, maxUsedDepth$1, xs$1);
        Object x = xs$1.next();
        RedBlackTree.Tree right = this.f$1(level + 1, size - 1 - leftSize, maxUsedDepth$1, xs$1);
        return new RedBlackTree.BlackTree(x, null, left, right);
    }

    private final RedBlackTree.Tree f$2(int level, int size, Iterator xs$2, int maxUsedDepth$2) {
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                Tuple2 tuple2 = (Tuple2)xs$2.next();
                if (tuple2 == null) {
                    throw new MatchError((Object)null);
                }
                Object T1 = tuple2._1();
                Object T2 = tuple2._2();
                return this.mkTree(level != maxUsedDepth$2 || level == 1, T1, T2, null, null);
            }
        }
        int leftSize = (size - 1) / 2;
        RedBlackTree.Tree left = this.f$2(level + 1, leftSize, xs$2, maxUsedDepth$2);
        Tuple2 tuple2 = (Tuple2)xs$2.next();
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Object T1 = tuple2._1();
        Object T2 = tuple2._2();
        RedBlackTree.Tree right = this.f$2(level + 1, size - 1 - leftSize, xs$2, maxUsedDepth$2);
        return new RedBlackTree.BlackTree(T1, T2, left, right);
    }

    private final RedBlackTree.Tree fk$1(RedBlackTree.Tree t, Function2 f$3) {
        RedBlackTree.Tree r2;
        Object k = t.key();
        Object v = t.value();
        RedBlackTree.Tree l = t.left();
        RedBlackTree.Tree r = t.right();
        RedBlackTree.Tree l2 = l == null ? null : this.fk$1(l, f$3);
        boolean keep = BoxesRunTime.unboxToBoolean(f$3.apply(k, v));
        RedBlackTree.Tree tree = r2 = r == null ? null : this.fk$1(r, f$3);
        if (!keep) {
            return this.join2(l2, r2);
        }
        if (l2 == l && r2 == r) {
            return t;
        }
        return this.join(l2, k, v, r2);
    }

    private final RedBlackTree.Tree fk$2(RedBlackTree.Tree t, Function1 f$4) {
        RedBlackTree.Tree r2;
        Object k = t.key();
        RedBlackTree.Tree l = t.left();
        RedBlackTree.Tree r = t.right();
        RedBlackTree.Tree l2 = l == null ? null : this.fk$2(l, f$4);
        boolean keep = BoxesRunTime.unboxToBoolean(f$4.apply(k));
        RedBlackTree.Tree tree = r2 = r == null ? null : this.fk$2(r, f$4);
        if (!keep) {
            return this.join2(l2, r2);
        }
        if (l2 == l && r2 == r) {
            return t;
        }
        return this.join(l2, k, t.value(), r2);
    }

    private final void fk$3(RedBlackTree.Tree t, ObjectRef tmpk$1, ObjectRef tmpd$1, Function2 p$1) {
        RedBlackTree.Tree jk;
        Object k = t.key();
        Object v = t.value();
        RedBlackTree.Tree l = t.left();
        RedBlackTree.Tree r = t.right();
        RedBlackTree.Tree l2k = null;
        RedBlackTree.Tree l2d = null;
        RedBlackTree.Tree r2k = null;
        RedBlackTree.Tree r2d = null;
        if (l != null) {
            this.fk$3(l, tmpk$1, tmpd$1, p$1);
            l2k = (RedBlackTree.Tree)tmpk$1.elem;
            l2d = (RedBlackTree.Tree)tmpd$1.elem;
        }
        boolean keep = BoxesRunTime.unboxToBoolean(p$1.apply(k, v));
        if (r != null) {
            this.fk$3(r, tmpk$1, tmpd$1, p$1);
            r2k = (RedBlackTree.Tree)tmpk$1.elem;
            r2d = (RedBlackTree.Tree)tmpd$1.elem;
        }
        RedBlackTree.Tree tree = !keep ? this.join2(l2k, r2k) : (jk = l2k == l && r2k == r ? t : this.join(l2k, k, v, r2k));
        RedBlackTree.Tree jd = keep ? this.join2(l2d, r2d) : (l2d == l && r2d == r ? t : this.join(l2d, k, v, r2d));
        tmpk$1.elem = jk;
        tmpd$1.elem = jd;
    }

    private final void fk$4(RedBlackTree.Tree t, ObjectRef tmpk$2, ObjectRef tmpd$2, Function1 p$2) {
        RedBlackTree.Tree jk;
        Object k = t.key();
        Object v = t.value();
        RedBlackTree.Tree l = t.left();
        RedBlackTree.Tree r = t.right();
        RedBlackTree.Tree l2k = null;
        RedBlackTree.Tree l2d = null;
        RedBlackTree.Tree r2k = null;
        RedBlackTree.Tree r2d = null;
        if (l != null) {
            this.fk$4(l, tmpk$2, tmpd$2, p$2);
            l2k = (RedBlackTree.Tree)tmpk$2.elem;
            l2d = (RedBlackTree.Tree)tmpd$2.elem;
        }
        boolean keep = BoxesRunTime.unboxToBoolean(p$2.apply(k));
        if (r != null) {
            this.fk$4(r, tmpk$2, tmpd$2, p$2);
            r2k = (RedBlackTree.Tree)tmpk$2.elem;
            r2d = (RedBlackTree.Tree)tmpd$2.elem;
        }
        RedBlackTree.Tree tree = !keep ? this.join2(l2k, r2k) : (jk = l2k == l && r2k == r ? t : this.join(l2k, k, v, r2k));
        RedBlackTree.Tree jd = keep ? this.join2(l2d, r2d) : (l2d == l && r2d == r ? t : this.join(l2d, k, v, r2d));
        tmpk$2.elem = jk;
        tmpd$2.elem = jd;
    }

    /*
     * WARNING - void declaration
     */
    private final RedBlackTree.Tree delLeft$1(RedBlackTree.Tree tree$1, Object k$1, Ordering ordering$1) {
        void apply_right;
        void apply_left;
        void apply_value;
        if (tree$1.left() instanceof RedBlackTree.BlackTree) {
            return this.balLeft(tree$1.key(), tree$1.value(), this.del(tree$1.left(), k$1, ordering$1), tree$1.right());
        }
        RedBlackTree.Tree tree = tree$1.right();
        RedBlackTree.Tree tree2 = this.del(tree$1.left(), k$1, ordering$1);
        Object b = tree$1.value();
        Object apply_key = tree$1.key();
        return new RedBlackTree.RedTree(apply_key, apply_value, apply_left, apply_right);
    }

    /*
     * WARNING - void declaration
     */
    private final RedBlackTree.Tree delRight$1(RedBlackTree.Tree tree$1, Object k$1, Ordering ordering$1) {
        void apply_right;
        void apply_left;
        void apply_value;
        if (tree$1.right() instanceof RedBlackTree.BlackTree) {
            return this.balRight(tree$1.key(), tree$1.value(), tree$1.left(), this.del(tree$1.right(), k$1, ordering$1));
        }
        RedBlackTree.Tree tree = this.del(tree$1.right(), k$1, ordering$1);
        RedBlackTree.Tree tree2 = tree$1.left();
        Object b = tree$1.value();
        Object apply_key = tree$1.key();
        return new RedBlackTree.RedTree(apply_key, apply_value, apply_left, apply_right);
    }

    private final int h$1(RedBlackTree.Tree t, int i) {
        while (t != null) {
            i = t instanceof RedBlackTree.BlackTree ? i + 1 : i;
            t = t.left();
        }
        return i + 1;
    }

    private RedBlackTree$() {
    }
}

