/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.artifactory.rest;

import com.cdancy.artifactory.rest.auth.AuthenticationType;
import com.google.common.io.BaseEncoding;
import java.util.Objects;
import org.jclouds.domain.Credentials;
import org.jclouds.javax.annotation.Nullable;

public class ArtifactoryAuthentication
extends Credentials {
    private final AuthenticationType authType;

    private ArtifactoryAuthentication(String authValue, AuthenticationType authType) {
        super(null, authType == AuthenticationType.Basic && authValue.contains(":") ? BaseEncoding.base64().encode(authValue.getBytes()) : authValue);
        this.authType = authType;
    }

    @Nullable
    public String authValue() {
        return this.credential;
    }

    public AuthenticationType authType() {
        return this.authType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String authValue;
        private AuthenticationType authType;

        public Builder credentials(String basicCredentials) {
            this.authValue = Objects.requireNonNull(basicCredentials);
            this.authType = AuthenticationType.Basic;
            return this;
        }

        public Builder token(String tokenCredentials) {
            this.authValue = Objects.requireNonNull(tokenCredentials);
            this.authType = AuthenticationType.Bearer;
            return this;
        }

        public ArtifactoryAuthentication build() {
            return new ArtifactoryAuthentication(this.authValue, this.authType != null ? this.authType : AuthenticationType.Anonymous);
        }
    }
}

