/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.artifactory.rest;

import com.cdancy.artifactory.rest.ArtifactoryApi;
import com.cdancy.artifactory.rest.ArtifactoryApiMetadata;
import com.cdancy.artifactory.rest.ArtifactoryAuthentication;
import com.cdancy.artifactory.rest.ArtifactoryUtils;
import com.cdancy.artifactory.rest.auth.AuthenticationType;
import com.cdancy.artifactory.rest.config.ArtifactoryAuthenticationModule;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.javax.annotation.Nullable;

public final class ArtifactoryClient
implements Closeable {
    private final String endPoint;
    private final ArtifactoryAuthentication credentials;
    private final ArtifactoryApi artifactoryApi;
    private final Properties overrides;

    public ArtifactoryClient() {
        this(null, null, null);
    }

    public ArtifactoryClient(@Nullable String endPoint, @Nullable ArtifactoryAuthentication authentication, @Nullable Properties overrides) {
        this.endPoint = endPoint != null ? endPoint : ArtifactoryUtils.inferEndpoint();
        this.credentials = authentication != null ? authentication : ArtifactoryUtils.inferAuthentication();
        this.overrides = this.mergeOverrides(overrides);
        this.artifactoryApi = this.createApi(this.endPoint, this.credentials, this.overrides);
    }

    private ArtifactoryApi createApi(String endPoint, ArtifactoryAuthentication authentication, Properties overrides) {
        return (ArtifactoryApi)ContextBuilder.newBuilder((ApiMetadata)new ArtifactoryApiMetadata.Builder().build()).endpoint(endPoint).modules((Iterable)Lists.newArrayList((Object[])new ArtifactoryAuthenticationModule[]{new ArtifactoryAuthenticationModule(authentication)})).overrides(overrides).buildApi(ArtifactoryApi.class);
    }

    private Properties mergeOverrides(Properties possibleOverrides) {
        Properties inferOverrides = ArtifactoryUtils.inferOverrides();
        if (possibleOverrides != null) {
            inferOverrides.putAll((Map<?, ?>)possibleOverrides);
        }
        return inferOverrides;
    }

    public String endPoint() {
        return this.endPoint;
    }

    @Deprecated
    public String credentials() {
        return this.authValue();
    }

    public Properties overrides() {
        return this.overrides;
    }

    public String authValue() {
        return this.credentials.authValue();
    }

    public AuthenticationType authType() {
        return this.credentials.authType();
    }

    public ArtifactoryApi api() {
        return this.artifactoryApi;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void close() throws IOException {
        if (this.api() != null) {
            this.api().close();
        }
    }

    public static class Builder {
        private String endPoint;
        private ArtifactoryAuthentication.Builder authBuilder;
        private Properties overrides;

        public Builder endPoint(String endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        public Builder credentials(String optionallyBase64EncodedCredentials) {
            this.authBuilder = ArtifactoryAuthentication.builder().credentials(optionallyBase64EncodedCredentials);
            return this;
        }

        public Builder token(String token) {
            this.authBuilder = ArtifactoryAuthentication.builder().token(token);
            return this;
        }

        public Builder overrides(Properties overrides) {
            this.overrides = overrides;
            return this;
        }

        public ArtifactoryClient build() {
            ArtifactoryAuthentication authentication = this.authBuilder != null ? this.authBuilder.build() : null;
            return new ArtifactoryClient(this.endPoint, authentication, this.overrides);
        }
    }
}

