/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.artifactory.rest.binders;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindListPropertiesToPath
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object properties) {
        Preconditions.checkArgument((boolean)(properties instanceof List), (Object)"binder is only valid for List");
        List props = (List)properties;
        Preconditions.checkArgument((props.size() > 0 ? 1 : 0) != 0, (Object)"properties List cannot be empty");
        StringBuilder propertiesProp = new StringBuilder();
        for (String prop : props) {
            String potentialKey;
            if (prop == null || (potentialKey = prop.trim()).length() <= 0) continue;
            propertiesProp.append(potentialKey).append(",");
        }
        if (propertiesProp.length() == 0) {
            throw new IllegalArgumentException("properties did not have any valid Strings");
        }
        propertiesProp.setLength(propertiesProp.length() - 1);
        return (R)request.toBuilder().addQueryParam("properties", new String[]{propertiesProp.toString()}).build();
    }
}

