/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.artifactory.rest.binders;

import com.cdancy.artifactory.rest.ArtifactoryUtils;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindMapToPath
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object properties) {
        Preconditions.checkArgument((boolean)(properties instanceof Map), (Object)"binder is only valid for Map");
        Map props = (Map)properties;
        Preconditions.checkArgument((props.size() > 0 ? 1 : 0) != 0, (Object)"properties Map cannot be empty");
        HttpRequest.Builder builder = request.toBuilder();
        for (Map.Entry prop : props.entrySet()) {
            String potentialKey = ((String)prop.getKey()).trim();
            if (potentialKey.length() <= 0) continue;
            String potentialValue = ArtifactoryUtils.collectionToString((Collection)prop.getValue(), ",");
            String encodedValue = "";
            try {
                if (potentialValue != null) {
                    encodedValue = potentialValue.replaceAll(" ", "%20");
                }
            }
            catch (Exception e) {
                encodedValue = potentialValue;
            }
            builder.addQueryParam(potentialKey, new String[]{encodedValue});
        }
        return (R)builder.build();
    }
}

