/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.artifactory.rest.binders;

import com.cdancy.artifactory.rest.ArtifactoryUtils;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindMatrixPropertiesToPath
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object properties) {
        Preconditions.checkArgument((boolean)(properties instanceof Map), (Object)"binder is only valid for Map");
        StringBuilder configuredEndpoint = new StringBuilder(request.getEndpoint().toString());
        Map matrixProperties = (Map)properties;
        if (matrixProperties.size() > 0) {
            for (Map.Entry prop : matrixProperties.entrySet()) {
                String potentialValue;
                String potentialKey = ((String)prop.getKey()).trim();
                if (potentialKey.length() <= 0) continue;
                configuredEndpoint.append(";").append(potentialKey);
                if (prop.getValue() == null || (potentialValue = ArtifactoryUtils.collectionToString((Collection)prop.getValue(), ",")).length() <= 0) continue;
                String encodedValue = "";
                try {
                    if (potentialValue != null) {
                        encodedValue = potentialValue.replaceAll(" ", "%20");
                    }
                }
                catch (Exception e) {
                    encodedValue = potentialValue;
                }
                configuredEndpoint.append("=").append(encodedValue);
            }
        }
        return (R)request.toBuilder().endpoint(configuredEndpoint.toString()).build();
    }
}

