/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.artifactory.rest.fallbacks;

import com.cdancy.artifactory.rest.domain.error.Error;
import com.cdancy.artifactory.rest.domain.error.Message;
import com.cdancy.artifactory.rest.domain.error.RequestStatus;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.jclouds.Fallback;

public final class ArtifactoryFallbacks {
    private static final JsonParser PARSER = new JsonParser();

    public static RequestStatus createPromoteBuildFromError(String message) {
        JsonElement possibleErrors;
        ArrayList<Message> messages = new ArrayList<Message>();
        ArrayList<Error> errors = new ArrayList<Error>();
        JsonReader reader = new JsonReader((Reader)new StringReader(message));
        reader.setLenient(true);
        JsonElement possibleMessages = PARSER.parse(reader).getAsJsonObject().get("messages");
        if (possibleMessages != null) {
            JsonArray jsonArray = possibleMessages.getAsJsonArray();
            for (JsonElement jsonElement : jsonArray) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                Message mess = Message.create(jsonObject.get("level").getAsString(), jsonObject.get("message").getAsString());
                messages.add(mess);
            }
        }
        if ((possibleErrors = PARSER.parse(message).getAsJsonObject().get("errors")) != null) {
            JsonArray jsonArray = possibleErrors.getAsJsonArray();
            for (JsonElement jsonElement : jsonArray) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                Error error = Error.create(jsonObject.get("status").getAsInt(), jsonObject.get("message").getAsString());
                errors.add(error);
            }
        }
        return RequestStatus.create(messages, errors);
    }

    public static final class RequestStatusFromError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable t) throws Exception {
            RequestStatus status;
            if (Preconditions.checkNotNull((Object)t, (Object)"throwable") != null && (status = ArtifactoryFallbacks.createPromoteBuildFromError(t.getMessage())) != null) {
                return status;
            }
            throw Throwables.propagate((Throwable)t);
        }
    }
}

