/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.artifactory.rest.features;

import com.cdancy.artifactory.rest.binders.BindMatrixPropertiesToPath;
import com.cdancy.artifactory.rest.domain.artifact.Artifact;
import com.cdancy.artifactory.rest.domain.error.RequestStatus;
import com.cdancy.artifactory.rest.fallbacks.ArtifactoryFallbacks;
import com.cdancy.artifactory.rest.filters.ArtifactoryAuthenticationFilter;
import com.cdancy.artifactory.rest.parsers.ArchivePathParser;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.io.Payload;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;

@Path(value="/")
@RequestFilters(value={ArtifactoryAuthenticationFilter.class})
public interface ArtifactApi {
    @Named(value="artifact:deploy")
    @Consumes(value={"application/json"})
    @Path(value="/{repoKey}/{itemPath}")
    @Headers(keys={"Content-Type"}, values={"application/octet-stream"})
    @PUT
    public Artifact deployArtifact(@PathParam(value="repoKey") String var1, @PathParam(value="itemPath") String var2, Payload var3, @Nullable @BinderParam(value=BindMatrixPropertiesToPath.class) Map<String, List<String>> var4);

    @Named(value="artifact:delete")
    @Path(value="/{repoKey}/{itemPath}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Consumes(value={"*/*"})
    @DELETE
    public boolean deleteArtifact(@PathParam(value="repoKey") String var1, @PathParam(value="itemPath") String var2);

    @Named(value="artifact:copy")
    @Consumes(value={"application/json"})
    @Path(value="/api/copy/{repoKey}/{itemPath}")
    @QueryParams(keys={"failFast", "suppressLayouts"}, values={"1", "0"})
    @Fallback(value=ArtifactoryFallbacks.RequestStatusFromError.class)
    @POST
    public RequestStatus copyArtifact(@PathParam(value="repoKey") String var1, @PathParam(value="itemPath") String var2, @QueryParam(value="to") String var3);

    @Named(value="artifact:move")
    @Consumes(value={"application/json"})
    @Path(value="/api/move/{repoKey}/{itemPath}")
    @QueryParams(keys={"failFast", "suppressLayouts"}, values={"1", "0"})
    @Fallback(value=ArtifactoryFallbacks.RequestStatusFromError.class)
    @POST
    public RequestStatus moveArtifact(@PathParam(value="repoKey") String var1, @PathParam(value="itemPath") String var2, @QueryParam(value="to") String var3);

    @Named(value="artifact:download")
    @Path(value="/{repoKey}/{itemPath}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"*/*"})
    @GET
    public InputStream downloadArtifact(@PathParam(value="repoKey") String var1, @PathParam(value="itemPath") String var2, @QueryParam(value="skipUpdateStats") boolean var3);

    @Named(value="artifact:downloadArchiveEntry")
    @Path(value="/{repoKey}/{archivePath}/{archiveEntryPath}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"*/*"})
    @GET
    public InputStream downloadArchiveEntry(@PathParam(value="repoKey") String var1, @PathParam(value="archivePath") @ParamParser(value=ArchivePathParser.class) String var2, @PathParam(value="archiveEntryPath") String var3);
}

