/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.artifactory.rest.features;

import com.cdancy.artifactory.rest.binders.BindListReposToPath;
import com.cdancy.artifactory.rest.binders.BindMapToPath;
import com.cdancy.artifactory.rest.domain.search.AQLResult;
import com.cdancy.artifactory.rest.domain.search.SearchBuildArtifacts;
import com.cdancy.artifactory.rest.domain.search.SearchResult;
import com.cdancy.artifactory.rest.filters.ArtifactoryAuthenticationFilter;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@Path(value="/api/search")
@Consumes(value={"application/json"})
@RequestFilters(value={ArtifactoryAuthenticationFilter.class})
public interface SearchApi {
    @Named(value="search:aql")
    @Path(value="/aql")
    @Produces(value={"text/plain"})
    @Payload(value="{aql_query}")
    @POST
    public AQLResult aql(@PayloadParam(value="aql_query") String var1);

    @Named(value="search:error-artifacts")
    @Path(value="/buildArtifacts")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    @Produces(value={"application/json"})
    @SelectJson(value={"results"})
    @POST
    public List<SearchResult> buildArtifacts(@BinderParam(value=BindToJsonPayload.class) SearchBuildArtifacts var1);

    @Named(value="search:gavc-search")
    @Path(value="/gavc")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    @Produces(value={"application/json"})
    @SelectJson(value={"results"})
    @GET
    public List<SearchResult> gavcSearch(@Nullable @QueryParam(value="g") String var1, @Nullable @QueryParam(value="a") String var2, @Nullable @QueryParam(value="v") String var3, @Nullable @QueryParam(value="c") String var4, @Nullable @BinderParam(value=BindListReposToPath.class) List<String> var5);

    @Named(value="search:latest-version-with-layout")
    @Path(value="/latestVersion")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"text/plain"})
    @GET
    public String latestVersionWithLayout(@Nullable @QueryParam(value="g") String var1, @Nullable @QueryParam(value="a") String var2, @Nullable @QueryParam(value="v") String var3, @Nullable @QueryParam(value="remote") String var4, @Nullable @BinderParam(value=BindListReposToPath.class) List<String> var5);

    @Named(value="search:property-search")
    @Path(value="/prop")
    @Produces(value={"application/json"})
    @SelectJson(value={"results"})
    @GET
    public List<SearchResult> propertySearch(@BinderParam(value=BindMapToPath.class) Map<String, List<String>> var1, @Nullable @BinderParam(value=BindListReposToPath.class) List<String> var2);

    @Named(value="search:not-downloaded-since")
    @Path(value="/usage")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    @Produces(value={"application/json"})
    @SelectJson(value={"results"})
    @GET
    public List<SearchResult> notDownloadedSince(@QueryParam(value="notUsedSince") long var1, @Nullable @QueryParam(value="createdBefore") Long var3, @Nullable @BinderParam(value=BindListReposToPath.class) List<String> var4);
}

