/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.artifactory.rest.features;

import com.cdancy.artifactory.rest.binders.BindListPropertiesToPath;
import com.cdancy.artifactory.rest.binders.BindMapPropertiesToPath;
import com.cdancy.artifactory.rest.domain.artifact.Artifact;
import com.cdancy.artifactory.rest.domain.storage.FileList;
import com.cdancy.artifactory.rest.domain.storage.StorageInfo;
import com.cdancy.artifactory.rest.filters.ArtifactoryAuthenticationFilter;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@Path(value="/api")
@Consumes(value={"application/json"})
@RequestFilters(value={ArtifactoryAuthenticationFilter.class})
public interface StorageApi {
    @Named(value="storage:set-item-properties")
    @Path(value="/storage/{repoKey}/{itemPath}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @QueryParams(keys={"recursive"}, values={"1"})
    @PUT
    public boolean setItemProperties(@PathParam(value="repoKey") String var1, @PathParam(value="itemPath") String var2, @BinderParam(value=BindMapPropertiesToPath.class) Map<String, List<String>> var3);

    @Named(value="storage:get-item-properties")
    @Path(value="/storage/{repoKey}/{itemPath}")
    @QueryParams(keys={"properties"})
    @Fallback(value=Fallbacks.EmptyMapOnNotFoundOr404.class)
    @SelectJson(value={"properties"})
    @GET
    public Map<String, List<String>> getItemProperties(@PathParam(value="repoKey") String var1, @PathParam(value="itemPath") String var2);

    @Named(value="storage:delete-item-properties")
    @Path(value="/storage/{repoKey}/{itemPath}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @QueryParams(keys={"recursive"}, values={"1"})
    @DELETE
    public boolean deleteItemProperties(@PathParam(value="repoKey") String var1, @PathParam(value="itemPath") String var2, @BinderParam(value=BindListPropertiesToPath.class) List<String> var3);

    @Named(value="storage:info")
    @Path(value="/storageinfo")
    @GET
    public StorageInfo storageInfo();

    @Named(value="storage:file-list")
    @Path(value="/storage/{repoKey}/{itemPath}")
    @QueryParams(keys={"list"}, values={"true"})
    @GET
    public FileList fileList(@PathParam(value="repoKey") String var1, @PathParam(value="itemPath") String var2, @Nullable @QueryParam(value="deep") Integer var3, @Nullable @QueryParam(value="depth") Integer var4, @Nullable @QueryParam(value="listFolders") Integer var5, @Nullable @QueryParam(value="includeRootPath") Integer var6);

    @Named(value="storage:file-info")
    @Path(value="/storage/{repoKey}/{itemPath}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @GET
    public Artifact fileInfo(@PathParam(value="repoKey") String var1, @PathParam(value="itemPath") String var2);
}

