/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.artifactory.rest.filters;

import com.cdancy.artifactory.rest.ArtifactoryAuthentication;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;

@Singleton
public class ArtifactoryAuthenticationFilter
implements HttpRequestFilter {
    private final ArtifactoryAuthentication authentication;

    @Inject
    ArtifactoryAuthenticationFilter(ArtifactoryAuthentication authentication) {
        this.authentication = authentication;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        switch (this.authentication.authType()) {
            case Basic: {
                String basicValue = (Object)((Object)this.authentication.authType()) + " " + this.authentication.authValue();
                return ((HttpRequest.Builder)request.toBuilder().addHeader("Authorization", new String[]{basicValue})).build();
            }
            case Bearer: {
                return ((HttpRequest.Builder)request.toBuilder().addHeader("X-JFrog-Art-Api", new String[]{this.authentication.authValue()})).build();
            }
        }
        return request.toBuilder().build();
    }
}

